/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.Auxiliaries;
import wile.engineersdecor.libmc.StandardBlocks;

public class SlabSliceBlock
extends StandardBlocks.WaterLoggable
implements StandardBlocks.IStandardBlock {
    public static final IntegerProperty PARTS = IntegerProperty.m_61631_((String)"parts", (int)0, (int)14);
    protected static final VoxelShape[] AABBs = new VoxelShape[]{Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.125, 0.0, 1.0, 1.0, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.375, 0.0, 1.0, 1.0, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.625, 0.0, 1.0, 1.0, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))};
    protected static final int[] num_slabs_contained_in_parts_ = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1, 1};
    private static boolean with_pickup = false;

    public static void on_config(boolean direct_slab_pickup) {
        with_pickup = direct_slab_pickup;
    }

    public SlabSliceBlock(long config, BlockBehaviour.Properties builder) {
        super(config, builder);
    }

    protected boolean is_cube(BlockState state) {
        return (Integer)state.m_61143_((Property)PARTS) == 7;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        if (!Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true)) {
            return;
        }
        if (with_pickup) {
            Auxiliaries.Tooltip.addInformation("engineersdecor.tooltip.slabpickup", tooltip);
        }
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return (this.config & 4L) != 0L ? StandardBlocks.IStandardBlock.RenderTypeHint.TRANSLUCENT : StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    public boolean m_48673_(BlockState state) {
        return false;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
        return AABBs[(Integer)state.m_61143_((Property)PARTS) & 0xF];
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.m_5940_(state, world, pos, selectionContext);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PARTS});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        if (state.m_60734_() == this) {
            int parts = (Integer)state.m_61143_((Property)PARTS);
            if (parts == 7) {
                return null;
            }
            if ((parts += parts < 7 ? 1 : -1) == 7) {
                state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            return (BlockState)state.m_61124_((Property)PARTS, (Comparable)Integer.valueOf(parts));
        }
        Direction face = context.m_43719_();
        BlockState placement_state = super.m_5573_(context);
        if (face == Direction.UP) {
            return (BlockState)placement_state.m_61124_((Property)PARTS, (Comparable)Integer.valueOf(0));
        }
        if (face == Direction.DOWN) {
            return (BlockState)placement_state.m_61124_((Property)PARTS, (Comparable)Integer.valueOf(14));
        }
        if (!face.m_122434_().m_122479_()) {
            return placement_state;
        }
        boolean isupper = context.m_43720_().m_7098_() - (double)context.m_8083_().m_123342_() > 0.5;
        return (BlockState)placement_state.m_61124_((Property)PARTS, (Comparable)Integer.valueOf(isupper ? 14 : 0));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        boolean isupper;
        if (context.m_43722_().m_41720_() != this.m_5456_()) {
            return false;
        }
        if (!context.m_7058_()) {
            return true;
        }
        Direction face = context.m_43719_();
        int parts = (Integer)state.m_61143_((Property)PARTS);
        if (parts == 7) {
            return false;
        }
        if (face == Direction.UP && parts < 7) {
            return true;
        }
        if (face == Direction.DOWN && parts > 7) {
            return true;
        }
        if (!face.m_122434_().m_122479_()) {
            return false;
        }
        boolean bl = isupper = context.m_43720_().m_7098_() - (double)context.m_8083_().m_123342_() > 0.5;
        return isupper ? parts == 0 : parts == 1;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    @Override
    public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
        return new ArrayList<ItemStack>(Collections.singletonList(new ItemStack((ItemLike)this.m_5456_(), num_slabs_contained_in_parts_[(Integer)state.m_61143_((Property)PARTS) & 0xF])));
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (world.f_46443_ || !with_pickup) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || Block.m_49814_((Item)stack.m_41720_()) != this) {
            return;
        }
        if (stack.m_41613_() >= stack.m_41741_()) {
            return;
        }
        Vec3 lv = player.m_20154_();
        Direction facing = Direction.m_122372_((float)((float)lv.f_82479_), (float)((float)lv.f_82480_), (float)((float)lv.f_82481_));
        if (facing != Direction.UP && facing != Direction.DOWN) {
            return;
        }
        if (state.m_60734_() != this) {
            return;
        }
        int parts = (Integer)state.m_61143_((Property)PARTS);
        if (facing == Direction.DOWN && parts <= 7) {
            if (parts > 0) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)PARTS, (Comparable)Integer.valueOf(parts - 1)), 3);
            } else {
                world.m_7471_(pos, false);
            }
        } else if (facing == Direction.UP && parts >= 7) {
            if (parts < 14) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)PARTS, (Comparable)Integer.valueOf(parts + 1)), 3);
            } else {
                world.m_7471_(pos, false);
            }
        } else {
            return;
        }
        if (!player.m_7500_()) {
            stack.m_41769_(1);
            if (player.m_150109_() != null) {
                player.m_150109_().m_6596_();
            }
        }
        SoundType st = this.getSoundType(state, (LevelReader)world, pos, null);
        world.m_5594_(player, pos, st.m_56777_(), SoundSource.BLOCKS, (st.m_56773_() + 1.0f) / 2.5f, 0.9f * st.m_56774_());
    }

    @Override
    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return (Integer)state.m_61143_((Property)PARTS) != 14 && super.m_7361_(world, pos, state, fluidState);
    }

    @Override
    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Integer)state.m_61143_((Property)PARTS) != 14 && super.m_6044_(world, pos, state, fluid);
    }
}

