/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;

public class Fluidics {
    @Nullable
    public static IFluidHandler handler(Level world, BlockPos pos, @Nullable Direction side) {
        return (IFluidHandler)FluidUtil.getFluidHandler((Level)world, (BlockPos)pos, (Direction)side).orElse(null);
    }

    public static boolean manualFluidHandlerInteraction(Level world, BlockPos pos, @Nullable Direction side, Player player, InteractionHand hand) {
        return Fluidics.manualTrackedFluidHandlerInteraction(world, pos, side, player, hand) != null;
    }

    public static boolean manualFluidHandlerInteraction(Player player, InteractionHand hand, IFluidHandler handler) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)handler);
    }

    @Nullable
    public static Tuple<Fluid, Integer> manualTrackedFluidHandlerInteraction(Level world, BlockPos pos, @Nullable Direction side, Player player, InteractionHand hand) {
        if (world.m_5776_()) {
            return null;
        }
        ItemStack held = player.m_21120_(hand);
        if (held.m_41619_()) {
            return null;
        }
        IFluidHandler fh = Fluidics.handler(world, pos, side);
        if (fh == null) {
            return null;
        }
        IItemHandler ih = (IItemHandler)player.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (ih == null) {
            return null;
        }
        FluidActionResult far = FluidUtil.tryFillContainerAndStow((ItemStack)held, (IFluidHandler)fh, (IItemHandler)ih, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (!far.isSuccess()) {
            far = FluidUtil.tryEmptyContainerAndStow((ItemStack)held, (IFluidHandler)fh, (IItemHandler)ih, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        }
        if (!far.isSuccess()) {
            return null;
        }
        ItemStack rstack = far.getResult().m_41777_();
        player.m_21008_(hand, far.getResult());
        IFluidHandler fh_before = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)held).orElse(null);
        IFluidHandler fh_after = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)rstack).orElse(null);
        if (fh_before == null || fh_after == null || fh_after.getTanks() != fh_before.getTanks()) {
            return null;
        }
        for (int i = 0; i < fh_before.getTanks(); ++i) {
            int vol_after;
            int vol_before = fh_before.getFluidInTank(i).getAmount();
            if (vol_before == (vol_after = fh_after.getFluidInTank(i).getAmount())) continue;
            return new Tuple((Object)(vol_before > 0 ? fh_before.getFluidInTank(i).getFluid() : fh_after.getFluidInTank(i).getFluid()), (Object)(vol_before - vol_after));
        }
        return null;
    }

    public static boolean manualFluidHandlerInteraction(Player player, InteractionHand hand, Level world, BlockPos pos, @Nullable Direction side) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)pos, (Direction)side);
    }

    public static int fill(Level world, BlockPos pos, Direction side, FluidStack fs, IFluidHandler.FluidAction action) {
        IFluidHandler fh = (IFluidHandler)FluidUtil.getFluidHandler((Level)world, (BlockPos)pos, (Direction)side).orElse(null);
        return fh == null ? 0 : fh.fill(fs, action);
    }

    public static int fill(Level world, BlockPos pos, Direction side, FluidStack fs) {
        return Fluidics.fill(world, pos, side, fs, IFluidHandler.FluidAction.EXECUTE);
    }

    public static class FluidContainerItemCapabilityWrapper
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private final LazyOptional<IFluidHandlerItem> handler_ = LazyOptional.of(() -> this);
        private final Function<ItemStack, CompoundTag> nbt_getter_;
        private final BiConsumer<ItemStack, CompoundTag> nbt_setter_;
        private final Predicate<FluidStack> validator_;
        private final ItemStack container_;
        private final int capacity_;
        private final int transfer_rate_;

        public FluidContainerItemCapabilityWrapper(ItemStack container, int capacity, int transfer_rate, Function<ItemStack, CompoundTag> nbt_getter, BiConsumer<ItemStack, CompoundTag> nbt_setter, Predicate<FluidStack> validator) {
            this.container_ = container;
            this.capacity_ = capacity;
            this.transfer_rate_ = transfer_rate;
            this.nbt_getter_ = nbt_getter;
            this.nbt_setter_ = nbt_setter;
            this.validator_ = validator != null ? validator : e -> true;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
            return capability == ForgeCapabilities.FLUID_HANDLER ? this.handler_.cast() : LazyOptional.empty();
        }

        protected FluidStack readnbt() {
            CompoundTag nbt = this.nbt_getter_.apply(this.container_);
            return nbt == null || nbt.m_128456_() ? FluidStack.EMPTY : FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
        }

        protected void writenbt(FluidStack fs) {
            CompoundTag nbt = new CompoundTag();
            if (!fs.isEmpty()) {
                fs.writeToNBT(nbt);
            }
            this.nbt_setter_.accept(this.container_, nbt);
        }

        public ItemStack getContainer() {
            return this.container_;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.readnbt();
        }

        public int getTankCapacity(int tank) {
            return this.capacity_;
        }

        public boolean isFluidValid(int tank, FluidStack fs) {
            return this.isFluidValid(fs);
        }

        public boolean isFluidValid(FluidStack fs) {
            return this.validator_.test(fs);
        }

        public int fill(FluidStack fs, IFluidHandler.FluidAction action) {
            if (fs.isEmpty() || !this.isFluidValid(fs) || this.container_.m_41613_() != 1) {
                return 0;
            }
            FluidStack tank = this.readnbt();
            int amount = Math.min(Math.min(fs.getAmount(), this.transfer_rate_), this.capacity_ - tank.getAmount());
            if (amount <= 0) {
                return 0;
            }
            if (tank.isEmpty()) {
                if (action.execute()) {
                    tank = new FluidStack(fs.getFluid(), amount, fs.getTag());
                    this.writenbt(tank);
                }
            } else {
                if (!tank.isFluidEqual(fs)) {
                    return 0;
                }
                if (action.execute()) {
                    tank.grow(amount);
                    this.writenbt(tank);
                }
            }
            return amount;
        }

        public FluidStack drain(FluidStack fs, IFluidHandler.FluidAction action) {
            if (fs.isEmpty() || this.container_.m_41613_() != 1) {
                return FluidStack.EMPTY;
            }
            FluidStack tank = this.readnbt();
            if (!tank.isEmpty() && !tank.isFluidEqual(fs)) {
                return FluidStack.EMPTY;
            }
            return this.drain(fs.getAmount(), action);
        }

        public FluidStack drain(int max, IFluidHandler.FluidAction action) {
            if (max <= 0 || this.container_.m_41613_() != 1) {
                return FluidStack.EMPTY;
            }
            FluidStack tank = this.readnbt();
            if (tank.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int amount = Math.min(Math.min(tank.getAmount(), max), this.transfer_rate_);
            FluidStack fs = tank.copy();
            fs.setAmount(amount);
            if (action.execute()) {
                tank.shrink(amount);
                this.writenbt(tank);
            }
            return fs;
        }
    }

    public static class Tank
    implements IFluidTank {
        private Predicate<FluidStack> validator_ = e -> true;
        private BiConsumer<Tank, Integer> interaction_notifier_ = (tank, diff) -> {};
        private FluidStack fluid_ = FluidStack.EMPTY;
        private int capacity_;
        private int fill_rate_;
        private int drain_rate_;

        public Tank(int capacity) {
            this(capacity, capacity, capacity);
        }

        public Tank(int capacity, int fill_rate, int drain_rate) {
            this(capacity, fill_rate, drain_rate, e -> true);
        }

        public Tank(int capacity, int fill_rate, int drain_rate, Predicate<FluidStack> validator) {
            this.capacity_ = capacity;
            this.setMaxFillRate(fill_rate);
            this.setMaxDrainRate(drain_rate);
            this.setValidator(validator);
        }

        public Tank load(CompoundTag nbt) {
            if (nbt.m_128425_("tank", 10)) {
                this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("tank")));
            } else {
                this.clear();
            }
            return this;
        }

        public CompoundTag save(CompoundTag nbt) {
            if (!this.isEmpty()) {
                nbt.m_128365_("tank", (Tag)this.fluid_.writeToNBT(new CompoundTag()));
            }
            return nbt;
        }

        public void reset() {
            this.clear();
        }

        public Tank clear() {
            this.setFluid(null);
            return this;
        }

        public int getCapacity() {
            return this.capacity_;
        }

        public Tank setCapacity(int capacity) {
            this.capacity_ = capacity;
            return this;
        }

        public int getMaxDrainRate() {
            return this.drain_rate_;
        }

        public Tank setMaxDrainRate(int rate) {
            this.drain_rate_ = Mth.m_14045_((int)rate, (int)0, (int)this.capacity_);
            return this;
        }

        public int getMaxFillRate() {
            return this.fill_rate_;
        }

        public Tank setMaxFillRate(int rate) {
            this.fill_rate_ = Mth.m_14045_((int)rate, (int)0, (int)this.capacity_);
            return this;
        }

        public Tank setValidator(Predicate<FluidStack> validator) {
            this.validator_ = validator != null ? validator : e -> true;
            return this;
        }

        public Tank setInteractionNotifier(BiConsumer<Tank, Integer> notifier) {
            this.interaction_notifier_ = notifier != null ? notifier : (tank, diff) -> {};
            return this;
        }

        public LazyOptional<IFluidHandler> createFluidHandler() {
            return LazyOptional.of(() -> new SingleTankFluidHandler(this));
        }

        public LazyOptional<IFluidHandler> createOutputFluidHandler() {
            return LazyOptional.of(() -> new SingleTankOutputFluidHandler(this));
        }

        @Nonnull
        public FluidStack getFluid() {
            return this.fluid_;
        }

        public void setFluid(@Nullable FluidStack stack) {
            this.fluid_ = stack == null ? FluidStack.EMPTY : stack;
        }

        public int getFluidAmount() {
            return this.fluid_.getAmount();
        }

        public boolean isEmpty() {
            return this.fluid_.isEmpty();
        }

        public boolean isFull() {
            return this.getFluidAmount() >= this.getCapacity();
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.validator_.test(stack);
        }

        public boolean isFluidEqual(FluidStack stack) {
            return stack == null ? this.fluid_.isEmpty() : this.fluid_.isFluidEqual(stack);
        }

        public int fill(FluidStack fs, IFluidHandler.FluidAction action) {
            if (fs == null || fs.isEmpty() || !this.isFluidValid(fs)) {
                return 0;
            }
            if (action.simulate()) {
                if (this.fluid_.isEmpty()) {
                    return Math.min(this.capacity_, fs.getAmount());
                }
                if (!this.fluid_.isFluidEqual(fs)) {
                    return 0;
                }
                return Math.min(this.capacity_ - this.fluid_.getAmount(), fs.getAmount());
            }
            if (this.fluid_.isEmpty()) {
                this.fluid_ = new FluidStack(fs, Math.min(this.capacity_, fs.getAmount()));
                return this.fluid_.getAmount();
            }
            if (!this.fluid_.isFluidEqual(fs)) {
                return 0;
            }
            int amount = this.capacity_ - this.fluid_.getAmount();
            if (fs.getAmount() < amount) {
                this.fluid_.grow(fs.getAmount());
                amount = fs.getAmount();
            } else {
                this.fluid_.setAmount(this.capacity_);
            }
            if (amount != 0) {
                this.interaction_notifier_.accept(this, amount);
            }
            return amount;
        }

        @Nonnull
        public FluidStack drain(int maxDrain) {
            return this.drain(maxDrain, IFluidHandler.FluidAction.EXECUTE);
        }

        @Nonnull
        public FluidStack drain(FluidStack fs, IFluidHandler.FluidAction action) {
            return fs.isEmpty() || !fs.isFluidEqual(this.fluid_) ? FluidStack.EMPTY : this.drain(fs.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int amount = Math.min(this.fluid_.getAmount(), maxDrain);
            FluidStack stack = new FluidStack(this.fluid_, amount);
            if (amount > 0 && action.execute()) {
                this.fluid_.shrink(amount);
                if (this.fluid_.isEmpty()) {
                    this.fluid_ = FluidStack.EMPTY;
                }
                if (amount != 0) {
                    this.interaction_notifier_.accept(this, -amount);
                }
            }
            return stack;
        }
    }

    private static class SingleTankOutputFluidHandler
    implements IFluidHandler {
        private final IFluidTank tank_;

        public SingleTankOutputFluidHandler(IFluidTank tank) {
            this.tank_ = tank;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.tank_.getFluid().copy();
        }

        public int getTankCapacity(int tank) {
            return this.tank_.getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.tank_.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.tank_.drain(maxDrain, action);
        }
    }

    public static class SingleTankFluidHandler
    implements IFluidHandler {
        private final IFluidTank tank_;

        public SingleTankFluidHandler(IFluidTank tank) {
            this.tank_ = tank;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.tank_.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tank_.getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tank_.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.tank_.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.tank_.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.tank_.drain(maxDrain, action);
        }
    }
}

