/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.Overlay;
import wile.engineersdecor.libmc.StandardBlocks;

public class EdChimneyBlock
extends StandardBlocks.Cutout {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;

    public EdChimneyBlock(long config, BlockBehaviour.Properties properties, AABB aabb) {
        super(config, properties, aabb);
    }

    public EdChimneyBlock(long config, BlockBehaviour.Properties builder) {
        this(config, builder, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWER});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return state;
        }
        int p = context.m_43725_().m_277086_(context.m_8083_());
        return (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(p == 0 ? 5 : p));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)POWER) + 1 & 0xF)), 3);
        Overlay.show(player, (Component)Component.m_237113_((String)((Integer)state.m_61143_((Property)POWER)).toString()));
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
        int p = world.m_277086_(pos);
        if (p != (Integer)state.m_61143_((Property)POWER)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(p)), 2);
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rnd) {
        if (state.m_60734_() != this) {
            return;
        }
        int p = (Integer)state.m_61143_((Property)POWER);
        if (p == 0) {
            return;
        }
        int end = 1 + rnd.m_188503_(10) * p / 15;
        for (int i = 0; i < end; ++i) {
            double rv = rnd.m_188500_() * (double)p / 5.0;
            world.m_7106_((ParticleOptions)(rv > 0.7 ? ParticleTypes.f_123755_ : (rv > 0.4 ? ParticleTypes.f_123762_ : ParticleTypes.f_123777_)), 0.5 + (double)pos.m_123341_() + rnd.m_188500_() * 0.2, 0.9 + (double)pos.m_123342_() + rnd.m_188500_() * 0.1, 0.5 + (double)pos.m_123343_() + rnd.m_188500_() * 0.2, -0.02 + rnd.m_188500_() * 0.04, 0.05 + rnd.m_188500_() * 0.1, -0.02 + rnd.m_188500_() * 0.04);
        }
    }
}

