/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorType;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.client.render.conveyor.BasicConveyorRender;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class DropConveyor
extends ConveyorBase {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "dropper");
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:block/conveyor/dropper");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:block/conveyor/dropper_off");
    public static final IConveyorType<DropConveyor> TYPE = new BasicConveyorType<DropConveyor>(NAME, false, true, DropConveyor::new, () -> new BasicConveyorRender(texture_on, texture_off));
    private static final VoxelShape REQUIRED_SPACE = Shapes.m_83048_((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    private VoxelShape cachedDownShape = Shapes.m_83040_();
    private boolean cachedOpenBelow = true;

    public DropConveyor(BlockEntity tile) {
        super(tile);
    }

    public IConveyorType<DropConveyor> getType() {
        return TYPE;
    }

    @Override
    public void handleInsertion(ItemEntity entity, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        if (!this.isPowered()) {
            boolean contact;
            BlockPos posDown = this.getBlockEntity().m_58899_().m_7495_();
            BlockEntity inventoryTile = this.getBlockEntity().m_58904_().m_7702_(posDown);
            boolean bl = contact = Math.abs(this.getFacing().m_122434_() == Direction.Axis.Z ? (double)this.getBlockEntity().m_58899_().m_123343_() + 0.5 - entity.m_20189_() : (double)this.getBlockEntity().m_58899_().m_123341_() + 0.5 - entity.m_20185_()) < 0.2;
            if (contact && !(inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                ItemUtils.tryInsertEntity(this.getBlockEntity().m_58904_(), posDown, Direction.UP, entity);
            }
            if (entity.m_6084_() && contact && this.isEmptySpace(this.getBlockEntity().m_58904_(), posDown, inventoryTile)) {
                entity.m_20334_(0.0, entity.m_20184_().f_82480_, 0.0);
                entity.m_6034_((double)this.getBlockEntity().m_58899_().m_123341_() + 0.5, (double)this.getBlockEntity().m_58899_().m_123342_() - 0.5, (double)this.getBlockEntity().m_58899_().m_123343_() + 0.5);
                if (!(inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                    ConveyorHandler.revertMagnetSuppression((Entity)entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
                }
            } else {
                super.handleInsertion(entity, conDir, distX, distZ);
            }
        } else {
            super.handleInsertion(entity, conDir, distX, distZ);
        }
    }

    boolean isEmptySpace(Level world, BlockPos pos, BlockEntity tile) {
        if (tile instanceof ConveyorHandler.IConveyorBlockEntity) {
            return true;
        }
        if (tile != null && tile.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).isPresent()) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60812_((BlockGetter)world, pos);
        if (shape != this.cachedDownShape) {
            this.cachedOpenBelow = !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82689_);
            this.cachedDownShape = shape;
        }
        return this.cachedOpenBelow;
    }
}

