/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.block;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.tile_entity.TileEntityMusicBox;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockMusicBox
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty POWERING = BooleanProperty.m_61465_((String)"powering");
    public static final BooleanProperty HAS_MUSIC = BooleanProperty.m_61465_((String)"has_music");
    public static final BooleanProperty HAS_INSTRUMENT = BooleanProperty.m_61465_((String)"has_instrument");

    public BlockMusicBox() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_MUSIC, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_INSTRUMENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())))).m_61124_((Property)f_54117_, (Comparable)context.m_8125_());
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            boolean powered = worldIn.m_276867_(pos);
            if (powered && ((Boolean)state.m_61143_((Property)POWERING)).booleanValue()) {
                return;
            }
            if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
            }
        }
    }

    private void ejectItem(Level world, BlockPos pos, BlockState state, boolean isMusic, boolean isBreaking) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TileEntityMusicBox) {
            ItemStack itemstack;
            TileEntityMusicBox te = (TileEntityMusicBox)blockEntity;
            if (isMusic) {
                itemstack = te.getNoteStack();
            } else {
                IItemInstrument instrument = te.getInstrument();
                ItemStack itemStack = itemstack = instrument != null ? new ItemStack((ItemLike)instrument) : ItemStack.f_41583_;
            }
            if (!itemstack.m_41619_()) {
                ItemEntity entity;
                if (!isBreaking) {
                    if (isMusic) {
                        te.removeNoteStack();
                        world.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_MUSIC, (Comparable)Boolean.FALSE), 3);
                    } else {
                        te.removeInstrument();
                        world.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_INSTRUMENT, (Comparable)Boolean.FALSE), 3);
                    }
                }
                if (isMusic) {
                    entity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), itemstack);
                    entity.m_20334_(world.f_46441_.m_188500_() * 0.2 - 0.1, 0.1, world.f_46441_.m_188500_() * 0.2 - 0.1);
                } else {
                    Direction backFace = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
                    int xOffset = backFace.m_122429_();
                    int zOffset = backFace.m_122431_();
                    entity = new ItemEntity(world, (double)pos.m_123341_() + (double)xOffset * 0.625, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + (double)zOffset * 0.625, itemstack);
                    double speed = world.f_46441_.m_188500_() * 0.1 + 0.2;
                    entity.m_20334_((double)xOffset * speed, 0.1, (double)zOffset * speed);
                }
                entity.m_32060_();
                world.m_7967_((Entity)entity);
            }
        }
    }

    public static void insertMusic(LevelAccessor worldIn, BlockPos pos, BlockState state, ItemStack noteStack) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof TileEntityMusicBox) {
            ((TileEntityMusicBox)blockEntity).setNoteStack(noteStack, true);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_MUSIC, (Comparable)Boolean.TRUE), 3);
        }
    }

    public static void insertInstrument(LevelAccessor worldIn, BlockPos pos, BlockState state, Item instrument) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof TileEntityMusicBox) {
            ((TileEntityMusicBox)blockEntity).setInstrument(instrument);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_INSTRUMENT, (Comparable)Boolean.TRUE), 3);
        }
        worldIn.m_247517_(null, pos, SoundEvents.f_12626_, SoundSource.BLOCKS);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (hit.m_82434_() == Direction.UP && ((Boolean)state.m_61143_((Property)HAS_MUSIC)).booleanValue()) {
            if (heldItem.m_41720_() instanceof IItemInstrument && !((Boolean)state.m_61143_((Property)HAS_INSTRUMENT)).booleanValue()) {
                return InteractionResult.PASS;
            }
            this.ejectItem(worldIn, pos, state, true, false);
            return InteractionResult.SUCCESS;
        }
        if (hit.m_82434_() == ((Direction)state.m_61143_((Property)f_54117_)).m_122424_() && ((Boolean)state.m_61143_((Property)HAS_INSTRUMENT)).booleanValue()) {
            if (heldItem.m_41720_() == Items.MUSIC_SHEET.get() && !((Boolean)state.m_61143_((Property)HAS_MUSIC)).booleanValue()) {
                return InteractionResult.PASS;
            }
            worldIn.m_247517_(null, pos, SoundEvents.f_12627_, SoundSource.BLOCKS);
            this.ejectItem(worldIn, pos, state, false, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != Blocks.MUSIC_BOX.get() || newState.m_60734_() != Blocks.MUSIC_BOX.get()) {
            this.ejectItem(worldIn, pos, state, true, true);
            this.ejectItem(worldIn, pos, state, false, true);
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, HAS_MUSIC, HAS_INSTRUMENT, f_54117_, POWERING});
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.m_60746_(blockAccess, pos, side);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.m_61143_((Property)POWERING)).booleanValue()) {
            return 0;
        }
        return ((Direction)blockState.m_61143_((Property)f_54117_)).m_122428_() == side ? 15 : 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TileEntityMusicBox(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, blockState1, t) -> {
            if (t instanceof TileEntityMusicBox) {
                TileEntityMusicBox.tick(level1, blockPos, blockState1, (TileEntityMusicBox)t);
            }
        };
    }
}

