/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.registry.helper;

import com.teamabnormals.blueprint.client.BlueprintChestMaterials;
import com.teamabnormals.blueprint.client.renderer.block.ChestBlockEntityWithoutLevelRenderer;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.entity.BlueprintChestBlockEntity;
import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.common.item.BEWLRBlockItem;
import com.teamabnormals.blueprint.common.item.BEWLRFuelBlockItem;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.woodworks.client.renderer.block.DrawerBlockEntityWithoutLevelRenderer;
import com.teamabnormals.woodworks.common.block.ClosetBlock;
import com.teamabnormals.woodworks.common.block.TrappedClosetBlock;
import com.teamabnormals.woodworks.common.block.entity.ClosetBlockEntity;
import com.teamabnormals.woodworks.common.block.entity.TrappedClosetBlockEntity;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class WoodworksBlockSubRegistryHelper
extends BlockSubRegistryHelper {
    public WoodworksBlockSubRegistryHelper(RegistryHelper parent) {
        super(parent);
    }

    public RegistryObject<BlueprintChestBlock> createNonFuelChestBlock(String name, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials((String)modId, (String)name, (boolean)false);
        RegistryObject block = this.deferredRegister.register(name + "_chest", () -> new BlueprintChestBlock(chestMaterialsName, properties));
        this.itemRegister.register(name + "_chest", () -> new BEWLRBlockItem((Block)block.get(), new Item.Properties(), () -> () -> WoodworksBlockSubRegistryHelper.chestBEWLR(false)));
        return block;
    }

    public RegistryObject<BlueprintTrappedChestBlock> createTrappedChestBlock(String name, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register("trapped_" + name + "_chest", () -> new BlueprintTrappedChestBlock(modId + ":" + name + "_trapped", properties));
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials((String)modId, (String)name, (boolean)true);
        this.itemRegister.register("trapped_" + name + "_chest", () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> WoodworksBlockSubRegistryHelper.chestBEWLR(true), 300));
        return block;
    }

    public RegistryObject<BlueprintTrappedChestBlock> createNonFuelTrappedChestBlock(String name, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register("trapped_" + name + "_chest", () -> new BlueprintTrappedChestBlock(modId + ":" + name + "_trapped", properties));
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials((String)modId, (String)name, (boolean)true);
        this.itemRegister.register("trapped_" + name + "_chest", () -> new BEWLRBlockItem((Block)block.get(), new Item.Properties(), () -> () -> WoodworksBlockSubRegistryHelper.chestBEWLR(true)));
        return block;
    }

    public RegistryObject<ClosetBlock> createClosetBlock(String name, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials((String)modId, (String)name, (boolean)false);
        RegistryObject block = this.deferredRegister.register(name + "_closet", () -> new ClosetBlock(chestMaterialsName, properties));
        this.itemRegister.register(name + "_closet", () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> WoodworksBlockSubRegistryHelper.closetBEWLR(false), 300));
        return block;
    }

    public RegistryObject<TrappedClosetBlock> createTrappedClosetBlock(String name, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register("trapped_" + name + "_closet", () -> new TrappedClosetBlock(modId + ":" + name + "_trapped", properties));
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials((String)modId, (String)name, (boolean)true);
        this.itemRegister.register("trapped_" + name + "_closet", () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> WoodworksBlockSubRegistryHelper.closetBEWLR(true), 300));
        return block;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR chestBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintTrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_())));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR closetBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new DrawerBlockEntityWithoutLevelRenderer<TrappedClosetBlockEntity>((BlockEntityRenderDispatcher)dispatcher, (EntityModelSet)entityModelSet, new TrappedClosetBlockEntity(BlockPos.f_121853_, ((TrappedClosetBlock)((Object)((Object)WoodworksBlocks.TRAPPED_BAMBOO_CLOSET.get()))).m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new DrawerBlockEntityWithoutLevelRenderer<ClosetBlockEntity>((BlockEntityRenderDispatcher)dispatcher, (EntityModelSet)entityModelSet, new ClosetBlockEntity(BlockPos.f_121853_, ((ClosetBlock)((Object)((Object)WoodworksBlocks.BAMBOO_CLOSET.get()))).m_49966_())));
    }
}

