//package com.rosemods.wintertale.core.data.client;
//
//import com.google.gson.JsonElement;
//import com.google.gson.JsonObject;
//import com.mojang.serialization.Codec;
//import com.mojang.serialization.JsonOps;
//import com.mojang.serialization.codecs.RecordCodecBuilder;
//import com.rosemods.wintertale.core.WinterTale;
//import com.rosemods.wintertale.core.registry.WinterTaleParticleTypes;
//import lombok.SneakyThrows;
//import net.minecraft.core.particles.ParticleType;
//import net.minecraft.data.CachedOutput;
//import net.minecraft.data.DataGenerator;
//import net.minecraft.data.DataProvider;
//import net.minecraft.data.PackOutput;
//import net.minecraft.resources.ResourceLocation;
//import net.minecraftforge.data.event.GatherDataEvent;
//import net.minecraftforge.registries.ForgeRegistries;
//
//import java.io.IOException;
//import java.nio.file.Path;
//import java.util.Arrays;
//import java.util.LinkedHashMap;
//import java.util.List;
//import java.util.Map;
//import java.util.concurrent.CompletableFuture;
//
//public class WinterTaleParticleProvider implements DataProvider {
//    private final PackOutput output;
//    private final String modId;
//    private final Map<String, ParticleDefinition> particles = new LinkedHashMap<>();
//
//    public WinterTaleParticleProvider(PackOutput output) {
//        this.output = output;
//        this.modId = WinterTale.MOD_ID;
//    }
//
//    @Override
//    protected void addParticles() {
//        this.add(WinterTaleParticleTypes.CUPIDS_ARROW.get(), "cupids_arrow");
//        this.add(WinterTaleParticleTypes.WILL_O_THE_WISP.get(), "will_o_the_wisp0", "will_o_the_wisp1", "will_o_the_wisp2");
//    }
//
//
//    protected void add(ParticleType<?> particle, String... textures) {
//        this.particles.put(ForgeRegistries.PARTICLE_TYPES.getKey(particle).getPath(),
//                new ParticleDefinition(Arrays.stream(textures).map(s -> new ResourceLocation(WinterTale.MOD_ID, s).toString()).toList()));
//    }
//
//    @SneakyThrows
//    @Override
//    public CompletableFuture<?> run(CachedOutput cachedOutput) {
//        JsonObject particleJson = new JsonObject();
//        particleJson.addProperty("texture", modId + ":particle/my_particle");
//
//        saveParticle(cachedOutput, particleJson, "my_particle");
//        return null;
//    }
//
//    private void saveParticle(CachedOutput cachedOutput, JsonObject particleJson, String name) throws IOException {
//        Path path = output.getOutputFolder().resolve("assets/" + modId + "/particles/" + name + ".json");
//        DataProvider.saveStable(cachedOutput, particleJson, path);
//    }
//
//    @Override
//    public String getName() {
//        return "Particles: " + WinterTale.MOD_ID;
//    }
//
//    private record ParticleDefinition(List<String> entries) {
//        private static final Codec<ParticleDefinition> CODEC = RecordCodecBuilder.create(textures -> textures.group(Codec.STRING.listOf().fieldOf("textures").forGetter(ParticleProvider.ParticleDefinition::entries)).apply(textures, ParticleProvider.ParticleDefinition::new));
//
//        public JsonElement serialize() {
//            return CODEC.encodeStart(JsonOps.INSTANCE, this).getOrThrow(false, LOGGER::error);
//        }
//    }
//}
