//package com.rosemods.wintertale.core.data.client;
//
//import com.mojang.datafixers.util.Pair;
//import com.rosemods.wintertale.common.block.*;
//import com.rosemods.wintertale.core.WinterTale;
//import com.rosemods.wintertale.integration.blueprint.VerticalSlabBlock;
//import com.teamabnormals.blueprint.core.Blueprint;
//import net.minecraft.core.Direction;
//import net.minecraft.data.PackOutput;
//import net.minecraft.resources.ResourceLocation;
//import net.minecraft.world.item.Item;
//import net.minecraft.world.level.ItemLike;
//import net.minecraft.world.level.block.*;
//import net.minecraft.world.level.block.state.properties.*;
//import net.minecraftforge.client.model.generators.BlockStateProvider;
//import net.minecraftforge.client.model.generators.ConfiguredModel;
//import net.minecraftforge.client.model.generators.ModelFile;
//import net.minecraftforge.common.data.ExistingFileHelper;
//import net.minecraftforge.data.event.GatherDataEvent;
//import net.minecraftforge.registries.ForgeRegistries;
//import net.minecraftforge.registries.RegistryObject;
//
//import java.util.function.Function;
//import java.util.function.Supplier;
//
//import static com.rosemods.wintertale.core.registry.WinterTaleBlocks.*;
//
//public class WinterTaleModelProvider extends BlockStateProvider {
//    public WinterTaleModelProvider(PackOutput output, ExistingFileHelper exFileHelper) {
//        super(output, WinterTale.MOD_ID, exFileHelper);
//    }
//
//    @Override
//    protected void registerStatesAndModels() {
//
//        this.signs(HOLLY_SIGNS, HOLLY_PLANKS);
//        this.hedge(HOLLY_HEDGE, HOLLY_LEAVES, HOLLY_LOG);
//        this.leafCarpet(HOLLY_LEAF_CARPET, this.blockTexture(HOLLY_LEAVES.get()));
//        this.leafPile(HOLLY_LEAF_PILE, this.blockTexture(HOLLY_LEAVES.get()), false);
//        this.verticalPlanks(VERTICAL_HOLLY_PLANKS, this.blockTexture(HOLLY_PLANKS.get()));
//        this.verticalSlab(HOLLY_VERTICAL_SLAB, this.blockTexture(HOLLY_PLANKS.get()));
//        this.post(HOLLY_POST, this.blockTexture(HOLLY_LOG.get()));
//        this.post(STRIPPED_HOLLY_POST, this.blockTexture(STRIPPED_HOLLY_LOG.get()));
//        this.chests(HOLLY_CHEST, HOLLY_TRAPPED_CHEST, this.blockTexture(HOLLY_PLANKS.get()));
//
//        // chestnut
//        this.signs(CHESTNUT_SIGNS, CHESTNUT_PLANKS);
//        this.hedge(CHESTNUT_HEDGE, CHESTNUT_LEAVES, CHESTNUT_LOG);
//        this.leafCarpet(CHESTNUT_LEAF_CARPET, this.blockTexture(CHESTNUT_LEAVES.get()));
//        this.leafPile(CHESTNUT_LEAF_PILE, this.blockTexture(CHESTNUT_LEAVES.get()), true);
//        this.verticalPlanks(VERTICAL_CHESTNUT_PLANKS, this.blockTexture(CHESTNUT_PLANKS.get()));
//        this.verticalSlab(CHESTNUT_VERTICAL_SLAB, this.blockTexture(CHESTNUT_PLANKS.get()));
//        this.post(CHESTNUT_POST, this.blockTexture(CHESTNUT_LOG.get()));
//        this.post(STRIPPED_CHESTNUT_POST, this.blockTexture(STRIPPED_CHESTNUT_LOG.get()));
//        this.chests(CHESTNUT_CHEST, CHESTNUT_TRAPPED_CHEST, this.blockTexture(CHESTNUT_PLANKS.get()));
//
//        // pine
//        this.signs(PINE_SIGNS, PINE_PLANKS);
//        this.hedge(PINE_HEDGE, PINE_LEAVES, PINE_LOG);
//        this.leafCarpet(PINE_LEAF_CARPET, this.blockTexture(PINE_LEAVES.get()));
//        this.leafPile(PINE_LEAF_PILE, this.blockTexture(PINE_LEAVES.get()), false);
//        this.verticalPlanks(VERTICAL_PINE_PLANKS, this.blockTexture(PINE_PLANKS.get()));
//        this.verticalSlab(PINE_VERTICAL_SLAB, this.blockTexture(PINE_PLANKS.get()));
//        this.post(PINE_POST, this.blockTexture(PINE_LOG.get()));
//        this.post(WEATHERED_PINE_POST, this.blockTexture(WEATHERED_PINE_LOG.get()));
//        this.post(STRIPPED_PINE_POST, this.blockTexture(STRIPPED_PINE_LOG.get()));
//        this.chests(PINE_CHEST, PINE_TRAPPED_CHEST, this.blockTexture(PINE_PLANKS.get()));
//
//        // pinecone
//
//
//
//        this.generatedItem(FEATHER_WING.get(), TextureFolder.BLOCK);
//
//        this.generatedItem(FEATHER_ORNAMENT.get(), TextureFolder.BLOCK);
//
//
//        this.verticalSlab(PINECONE_SHINGLE_VERTICAL_SLAB, this.blockTexture(PINECONE_SHINGLES.get()));
//
//        // snow
//        this.verticalSlab(SNOW_VERTICAL_SLAB, this.mcLoc("block/snow_block"), this.mcLoc("block/snow"));
//        this.verticalSlab(SNOW_BRICK_VERTICAL_SLAB, this.blockTexture(SNOW_BRICKS.get()));
//
//        // packed ice
//        this.verticalSlab(PACKED_ICE_VERTICAL_SLAB, this.blockTexture(Blocks.PACKED_ICE));
//        this.verticalSlab(PACKED_ICE_BRICK_VERTICAL_SLAB, this.blockTexture(PACKED_ICE_BRICKS.get()));
//
//        // blue ice
//        this.verticalSlab(BLUE_ICE_VERTICAL_SLAB, this.blockTexture(Blocks.BLUE_ICE));
//        this.verticalSlab(BLUE_ICE_BRICK_VERTICAL_SLAB, this.blockTexture(BLUE_ICE_BRICKS.get()));
//
//        // shale
//        this.verticalSlab(SHALE_VERTICAL_SLAB, this.blockTexture(SHALE.get()));
//        this.verticalSlab(POLISHED_SHALE_VERTICAL_SLAB, this.blockTexture(POLISHED_SHALE.get()));
//        this.verticalSlab(POLISHED_SHALE_BRICK_VERTICAL_SLAB, this.blockTexture(POLISHED_SHALE_BRICKS.get()));
//
//        // deepslate
//        // decorations
//
//
//
//
//        this.verticalSlab(LUNALITE_VERTICAL_SLAB, this.blockTexture(LUNALITE.get()), this.modLoc("block/lunalite"), this.modLoc("block/lunalite_bottom"), this.modLoc("block/lunalite_top"));
//        this.verticalSlab(CUT_LUNALITE_VERTICAL_SLAB, this.blockTexture(CUT_LUNALITE.get()), this.modLoc("block/cut_lunalite"), this.modLoc("block/smooth_lunalite"), this.modLoc("block/lunalite_top"));
//        this.verticalSlab(CUT_LUNALITE_BRICK_VERTICAL_SLAB, this.blockTexture(CUT_LUNALITE_BRICKS.get()), this.modLoc("block/cut_lunalite_bricks"), this.modLoc("block/smooth_lunalite"), this.modLoc("block/lunalite_top"));
//
//        this.models().cubeBottomTop("smooth_lunalite_slab_double", this.modLoc("block/smooth_lunalite_slab"), this.modLoc("block/smooth_lunalite"), this.modLoc("block/smooth_lunalite"));
//        this.verticalSlab(SMOOTH_LUNALITE_VERTICAL_SLAB, this.blockTexture(SMOOTH_LUNALITE.get()));
//
//        // ginger
//
//
//        this.verticalSlab(GINGERBREAD_BRICK_VERTICAL_SLAB, this.blockTexture(GINGERBREAD_BRICKS.get()));
//
//
//        this.verticalSlab(GLAZED_GINGERBREAD_BRICK_VERTICAL_SLAB, this.blockTexture(GLAZED_GINGERBREAD_BRICKS.get()), this.blockTexture(GLAZED_GINGERBREAD_BRICKS.get()), this.blockTexture(GLAZED_GINGERBREAD_BRICKS.get()), this.modLoc("block/glazed_gingerbread_top"));
//
//
//
//
//        // dry moss
//        this.verticalSlab(DRY_MOSSY_COBBLESTONE_VERTICAL_SLAB, this.blockTexture(DRY_MOSSY_COBBLESTONE.get()));
//        this.verticalSlab(DRY_MOSSY_STONE_BRICK_VERTICAL_SLAB, this.blockTexture(DRY_MOSSY_STONE_BRICKS.get()));
//        this.verticalSlab(DRY_MOSSY_COBBLESTONE_BRICK_VERTICAL_SLAB, this.blockTexture(DRY_MOSSY_COBBLESTONE_BRICKS.get()));
//        this.verticalSlab(DRY_MOSSY_COBBLESTONE_TILE_VERTICAL_SLAB, this.blockTexture(DRY_MOSSY_COBBLESTONE_TILES.get()));
//    }
//
//    // Items //
//
//    private void itemModel(RegistryObject<Block> block) {
//        this.itemModels().withExistingParent(getItemName(block.get()), this.blockTexture(block.get()));
//    }
//
//    private void generatedItem(ItemLike item, TextureFolder folder) {
//        String name = getItemName(item);
//        this.itemModels().withExistingParent(name, "item/generated").texture("layer0", this.modLoc(folder.format(name)));
//    }
//
//    // Blocks //
//
//
////blueprint
//    private void signs(Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> signs, Supplier<Block> planks) {
//        this.signBlock(signs.getFirst().get(), signs.getSecond().get(), this.blockTexture(planks.get()));
//        this.generatedItem(signs.getFirst().get(), TextureFolder.ITEM);
//    }
//
//
//
//    // Blueprint Models //
//
//    private void hedge(RegistryObject<Block> hedge, Supplier<Block> leaves, Supplier<Block> log) {
//        String name = getItemName(hedge.get());
//        ModelFile post = this.models().withExistingParent(name + "_post", "blueprint:block/hedge_post").texture("leaf", this.blockTexture(leaves.get())).texture("log", this.blockTexture(log.get())).renderType("cutout");
//        ModelFile side = this.models().withExistingParent(name + "_side", "blueprint:block/hedge_side").texture("leaf", this.blockTexture(leaves.get())).renderType("cutout");
//        ModelFile extend = this.models().withExistingParent(name + "_extend", "blueprint:block/hedge_extend").texture("leaf", this.blockTexture(leaves.get())).renderType("cutout");
//
//        this.itemModels().withExistingParent(name, this.modLoc("block/" + name + "_post"));
//        this.getMultipartBuilder(hedge.get())
//                .part().modelFile(post).addModel().condition(BooleanProperty.create("extend"), false).end()
//                .part().modelFile(extend).addModel().condition(BooleanProperty.create("extend"), true).end()
//                .part().modelFile(side).uvLock(true).addModel().condition(CrossCollisionBlock.NORTH, true).end()
//                .part().modelFile(side).uvLock(true).rotationY(90).addModel().condition(CrossCollisionBlock.EAST, true).end()
//                .part().modelFile(side).uvLock(true).rotationY(180).addModel().condition(CrossCollisionBlock.SOUTH, true).end()
//                .part().modelFile(side).uvLock(true).rotationY(270).addModel().condition(CrossCollisionBlock.WEST, true).end();
//    }
//
//    //blueprint
//    private void chests(RegistryObject<BlueprintChestBlock> chest, RegistryObject<BlueprintTrappedChestBlock> trapped, ResourceLocation texture) {
//        ModelFile model = this.models().getBuilder(getItemName(chest.get())).texture("particle", texture);
//        this.simpleBlock(chest.get(), model);
//        this.simpleBlock(trapped.get(), model);
//        this.itemModels().withExistingParent(getItemName(chest.get()), "blueprint:item/template_chest");
//        this.itemModels().withExistingParent(getItemName(trapped.get()), "blueprint:item/template_chest");
//    }
//
//    private void leafCarpet(RegistryObject<Block> carpet, ResourceLocation texture) {
//        this.simpleBlock(carpet.get(), this.models().withExistingParent(getItemName(carpet.get()), "blueprint:block/leaf_carpet").texture("all", texture).renderType("cutout"));
//        this.itemModel(carpet);
//    }
//    //blueprint
//    private void post(RegistryObject<Block> post, ResourceLocation texture) {
//        ModelFile model = this.models().withExistingParent(getItemName(post.get()), "blueprint:block/post").texture("texture", texture);
//        ModelFile chain = this.models().getExistingFile(Blueprint.REGISTRY_HELPER.prefix("block/chain_small"));
//        ModelFile chainTop = this.models().getExistingFile(Blueprint.REGISTRY_HELPER.prefix("block/chain_small_top"));
//
//        this.itemModel(post);
//        this.getMultipartBuilder(post.get())
//                .part().modelFile(model).addModel().condition(BlockStateProperties.AXIS, Direction.Axis.Y).end()
//                .part().modelFile(model).rotationX(90).rotationY(90).addModel().condition(BlockStateProperties.AXIS, Direction.Axis.X).end()
//                .part().modelFile(model).rotationX(90).addModel().condition(BlockStateProperties.AXIS, Direction.Axis.Z).end()
//                .part().modelFile(chain).addModel().condition(BooleanProperty.create("chain_down"), true).end()
//                .part().modelFile(chainTop).addModel().condition(BooleanProperty.create("chain_up"), true).end()
//                .part().modelFile(chainTop).rotationX(90).addModel().condition(BooleanProperty.create("chain_north"), true).end()
//                .part().modelFile(chain).rotationX(90).addModel().condition(BooleanProperty.create("chain_south"), true).end()
//                .part().modelFile(chainTop).rotationX(90).rotationY(90).addModel().condition(BooleanProperty.create("chain_east"), true).end()
//                .part().modelFile(chain).rotationX(90).rotationY(90).addModel().condition(BooleanProperty.create("chain_west"), true).end();
//    }
//
//    private void leafPile(RegistryObject<Block> leafPile, ResourceLocation texture, boolean tinted) {
//        ModelFile model = this.models().withExistingParent(getItemName(leafPile.get()), "blueprint:block/" + (tinted ? "tinted_" : "") + "leaf_pile").texture("all", texture).renderType("cutout");
//
//        this.itemModels().withExistingParent(getItemName(leafPile.get()), "item/generated").texture("layer0", texture);
//        this.getMultipartBuilder(leafPile.get())
//                .part().modelFile(model).uvLock(true).rotationX(270).addModel().condition(BlockStateProperties.UP, true).end()
//                .part().modelFile(model).uvLock(true).rotationX(90).addModel().condition(BlockStateProperties.DOWN, true).end()
//                .part().modelFile(model).addModel().condition(BlockStateProperties.NORTH, true).end()
//                .part().modelFile(model).uvLock(true).rotationY(180).addModel().condition(BlockStateProperties.SOUTH, true).end()
//                .part().modelFile(model).uvLock(true).rotationY(90).addModel().condition(BlockStateProperties.EAST, true).end()
//                .part().modelFile(model).uvLock(true).rotationY(270).addModel().condition(BlockStateProperties.WEST, true).end();
//    }
//
//    private void verticalSlab(RegistryObject<Block> slab, ResourceLocation texture) {
//        this.verticalSlab(slab, texture, texture);
//    }
//
//    private void verticalSlab(RegistryObject<Block> slab, ResourceLocation fullBlock, ResourceLocation texture) {
//        this.verticalSlab(slab, fullBlock, texture, texture, texture);
//    }
//
//    private void verticalSlab(RegistryObject<Block> slab, ResourceLocation fullBlock, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
//        ModelFile model = this.models().withExistingParent(getItemName(slab.get()), "blueprint:block/vertical_slab").texture("top", top).texture("bottom", bottom).texture("side", side);
//
//        this.itemModel(slab);
//        this.getVariantBuilder(slab.get())
//                .partialState().with(VerticalSlabBlock.TYPE, VerticalSlabBlock.VerticalSlabType.NORTH).addModels(new ConfiguredModel(model, 0, 0, true))
//                .partialState().with(VerticalSlabBlock.TYPE, VerticalSlabBlock.VerticalSlabType.SOUTH).addModels(new ConfiguredModel(model, 0, 180, true))
//                .partialState().with(VerticalSlabBlock.TYPE, VerticalSlabBlock.VerticalSlabType.EAST).addModels(new ConfiguredModel(model, 0, 90, true))
//                .partialState().with(VerticalSlabBlock.TYPE, VerticalSlabBlock.VerticalSlabType.WEST).addModels(new ConfiguredModel(model, 0, 270, true))
//                .partialState().with(VerticalSlabBlock.TYPE, VerticalSlabBlock.VerticalSlabType.DOUBLE).addModels(new ConfiguredModel(this.models().getExistingFile(fullBlock)));
//    }
//
//    private void verticalPlanks(RegistryObject<Block> planks, ResourceLocation texture) {
//        ModelFile model = this.models().withExistingParent(getItemName(planks.get()), "blueprint:block/vertical_planks").texture("all", texture);
//
//        this.itemModel(planks);
//        this.simpleBlock(planks.get(), model);
//    }
//
//
//
//
//
//    // Util //
//
//    private static String getItemName(ItemLike item) {
//        return ForgeRegistries.ITEMS.getKey(item.asItem()).getPath();
//    }
//
//    private static String getBlockName(Block block) {
//        return ForgeRegistries.BLOCKS.getKey(block).getPath();
//    }
//
//    private enum TextureFolder {
//        ITEM, BLOCK;
//
//        public String format(String itemName) {
//            return this.name().toLowerCase() + '/' + itemName;
//        }
//    }
//
//}
