/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.render.DynamicWakeTexture;
import com.goby56.wakes.simulation.WakeHandler;
import com.goby56.wakes.simulation.WakeNode;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_761;
import org.joml.Matrix4f;

public class WakeTextureRenderer
implements WorldRenderEvents.AfterTranslucent {
    public static int nodesRendered = 0;

    public void afterTranslucent(WorldRenderContext context) {
        if (WakesClient.CONFIG_INSTANCE.disableMod) {
            return;
        }
        WakeHandler wakeHandler = WakeHandler.getInstance();
        if (wakeHandler == null || wakeHandler.resolutionResetScheduled) {
            return;
        }
        ArrayList<WakeNode> nodes = wakeHandler.getVisible(context.frustum());
        Matrix4f matrix = context.matrixStack().method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        context.lightmapTextureManager().method_3316();
        DynamicWakeTexture wakeTexture = DynamicWakeTexture.getInstance();
        int n = 0;
        for (WakeNode node : nodes) {
            if (node.isDead() || WakesClient.CONFIG_INSTANCE.wakeResolution.res != WakeNode.res) continue;
            class_243 screenSpace = node.getPos().method_1019(context.camera().method_19326().method_22882());
            float x = (float)screenSpace.field_1352;
            float y = (float)screenSpace.field_1351;
            float z = (float)screenSpace.field_1350;
            float distance = (float)Math.sqrt(screenSpace.method_1027());
            int waterCol = class_1163.method_4961((class_1920)context.world(), (class_2338)node.blockPos());
            int light = class_761.method_23794((class_1920)context.world(), (class_2338)node.blockPos());
            float a = (float)((-Math.pow(node.t, 2.0) + 1.0) * (double)WakesClient.CONFIG_INSTANCE.wakeOpacity);
            wakeTexture.populatePixels(node, distance, waterCol, a);
            wakeTexture.render(matrix, x, y, z, light);
            ++n;
        }
        RenderSystem.enableCull();
        nodesRendered = n;
    }
}

