/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.mixin;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.config.enums.EffectSpawningRule;
import com.goby56.wakes.duck.ProducesWake;
import com.goby56.wakes.particle.custom.SplashPlaneParticle;
import com.goby56.wakes.utils.WakesUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class WakeSpawnerMixin
implements ProducesWake {
    @Shadow
    private class_243 field_22467;
    @Shadow
    private class_1937 field_6002;
    @Unique
    private boolean onWaterSurface = false;
    @Unique
    private class_243 prevPosOnSurface = null;
    @Unique
    private class_243 numericalVelocity = class_243.field_1353;
    @Unique
    private double horizontalNumericalVelocity = 0.0;
    @Unique
    private double verticalNumericalVelocity = 0.0;
    @Unique
    private Float producingWaterLevel = null;
    @Unique
    private SplashPlaneParticle splashPlane;
    @Unique
    private boolean hasRecentlyTeleported = false;

    @Shadow
    public abstract boolean method_5869();

    @Shadow
    public abstract String toString();

    @Shadow
    public abstract boolean method_5799();

    @Override
    public boolean onWaterSurface() {
        return this.onWaterSurface;
    }

    @Override
    public class_243 getNumericalVelocity() {
        return this.numericalVelocity;
    }

    @Override
    public double getHorizontalVelocity() {
        return this.horizontalNumericalVelocity;
    }

    @Override
    public double getVerticalVelocity() {
        return this.verticalNumericalVelocity;
    }

    @Override
    public class_243 getPrevPos() {
        return this.prevPosOnSurface;
    }

    @Override
    public void setPrevPos(class_243 pos) {
        this.prevPosOnSurface = pos;
    }

    @Override
    public float producingHeight() {
        return this.producingWaterLevel.floatValue();
    }

    @Override
    public void setSplashPlane(SplashPlaneParticle particle) {
        this.splashPlane = particle;
    }

    @Override
    public void setRecentlyTeleported(boolean b) {
        this.hasRecentlyTeleported = b;
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        class_243 vel;
        this.onWaterSurface = this.method_5799() && !this.method_5869();
        class_1297 thisEntity = (class_1297)this;
        this.numericalVelocity = vel = this.calculateVelocity(thisEntity);
        this.horizontalNumericalVelocity = vel.method_37267();
        this.verticalNumericalVelocity = vel.field_1351;
        if (WakesClient.CONFIG_INSTANCE.disableMod) {
            return;
        }
        if (this.onWaterSurface && !this.hasRecentlyTeleported) {
            if (this.producingWaterLevel == null) {
                this.producingWaterLevel = Float.valueOf(WakesUtils.getWaterLevel(this.field_6002, thisEntity));
            }
            class_243 currPos = new class_243(thisEntity.method_23317(), (double)this.producingWaterLevel.floatValue(), thisEntity.method_23321());
            this.spawnEffects(thisEntity);
            this.setPrevPos(currPos);
        } else {
            this.producingWaterLevel = null;
            this.prevPosOnSurface = null;
        }
        this.setRecentlyTeleported(false);
    }

    @Inject(at={@At(value="TAIL")}, method={"onSwimmingStart"})
    private void onSwimmingStart(CallbackInfo ci) {
        if (WakesClient.CONFIG_INSTANCE.disableMod) {
            return;
        }
        class_1297 thisEntity = (class_1297)this;
        EffectSpawningRule rule = WakesUtils.getEffectRuleFromSource(thisEntity);
        if (rule.simulateWakes) {
            if (this.producingWaterLevel == null) {
                this.producingWaterLevel = Float.valueOf(WakesUtils.getWaterLevel(this.field_6002, thisEntity));
            }
            WakesUtils.placeFallSplash((class_1297)this);
        }
    }

    private void spawnEffects(class_1297 thisEntity) {
        EffectSpawningRule rule = WakesUtils.getEffectRuleFromSource(thisEntity);
        if (rule.simulateWakes) {
            WakesUtils.placeWakeTrail(thisEntity);
        }
        if (rule.renderPlanes && this.splashPlane == null && this.horizontalNumericalVelocity > 0.01) {
            WakesUtils.spawnSplashPlane(this.field_6002, thisEntity);
        }
    }

    private class_243 calculateVelocity(class_1297 thisEntity) {
        if (thisEntity instanceof class_746) {
            return thisEntity.method_18798();
        }
        return this.prevPosOnSurface == null ? class_243.field_1353 : this.field_22467.method_1020(this.prevPosOnSurface);
    }
}

