/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder;

import com.gmail.rawlxxxviii.visual_keybinder.KeyboardLayoutKey;
import java.util.List;
import net.minecraft.network.chat.Component;

public class KeyBoardLayout {
    private final List<KeyboardLayoutKey> keyboardLayoutKeys;
    private final Component name;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    public KeyBoardLayout(Component name, List<KeyboardLayoutKey> keyboardLayoutKeys) {
        this.keyboardLayoutKeys = keyboardLayoutKeys;
        this.name = name;
        this.updateMinMax();
    }

    private void updateMinMax() {
        this.minX = this.keyboardLayoutKeys.stream().mapToInt(KeyboardLayoutKey::getX).min().orElse(0);
        this.maxX = this.keyboardLayoutKeys.stream().mapToInt(x -> x.getX() + (x.isWide() ? 60 : 16)).max().orElse(0);
        this.minY = this.keyboardLayoutKeys.stream().mapToInt(KeyboardLayoutKey::getY).min().orElse(0);
        this.maxY = this.keyboardLayoutKeys.stream().mapToInt(x -> x.getY() + 16).max().orElse(0);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }

    public List<KeyboardLayoutKey> getKeyboardLayoutKeys() {
        return this.keyboardLayoutKeys;
    }

    public Component getName() {
        return this.name;
    }
}

