/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass.network;

import com.brokenkeyboard.usefulspyglass.handler.ServerHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class MarkEntityPacket {
    private final int entityID;
    private final ResourceLocation dimension;

    public MarkEntityPacket(int entityID, ResourceLocation dimension) {
        this.entityID = entityID;
        this.dimension = dimension;
    }

    public MarkEntityPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.dimension = buf.m_130281_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130085_(this.dimension);
    }

    public static void handle(MarkEntityPacket packet, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ServerHandler.markEntity(context.getSender(), packet.entityID, packet.dimension));
        supplier.get().setPacketHandled(true);
    }
}

