/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.TooltipInfo;
import com.brokenkeyboard.usefulspyglass.config.ClientConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class InfoOverlay {
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    public static HitResult hitResult = null;
    public static List<TooltipInfo> tooltipList;
    public static int rectangleWidth;
    public static int rectangleHeight;
    public static int rectangleX;
    public static int rectangleY;

    private static void setComponent(List<TooltipInfo> list) {
        tooltipList = list;
        rectangleWidth = InfoOverlay.getLongest(tooltipList);
        rectangleHeight = 0;
        int screenWidth = CLIENT.m_91268_().m_85445_();
        int screenHeight = CLIENT.m_91268_().m_85446_();
        for (TooltipInfo tooltip : tooltipList) {
            rectangleHeight += tooltip.getHeight() + (hitResult instanceof BlockHitResult && tooltipList.size() == 1 ? 16 - tooltip.getHeight() : 0);
        }
        rectangleX = (int)((double)screenWidth * (Double)ClientConfig.HUD_X.get() - (double)rectangleWidth * 0.5);
        if (rectangleX - 4 < 0) {
            rectangleX = 4;
        } else if (rectangleX + rectangleWidth + 4 > screenWidth) {
            rectangleX = screenWidth - rectangleWidth - 4;
        }
        rectangleY = (int)((double)CLIENT.m_91268_().m_85446_() * (Double)ClientConfig.HUD_Y.get());
        if (rectangleY - 4 < 0) {
            rectangleY = 4;
        } else if (rectangleY + rectangleHeight + 2 > screenHeight) {
            rectangleY = screenHeight - rectangleHeight - 4;
        }
    }

    public static void setHitResult(HitResult result) {
        EntityHitResult entityHit;
        hitResult = result;
        if (hitResult == null) {
            return;
        }
        ArrayList<TooltipInfo> tooltipList = new ArrayList<TooltipInfo>();
        HitResult hitResult = InfoOverlay.hitResult;
        if (hitResult instanceof EntityHitResult && (hitResult = (entityHit = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)hitResult;
            name = Component.m_237113_((String)entity.m_5446_().getString()).m_130940_(InfoOverlay.getColor(entity));
            tooltipList.add(new TooltipInfo.TextTooltip(ClientTooltipComponent.m_169948_((FormattedCharSequence)name.m_7532_())));
            HashMap<TooltipInfo.Icon, ClientTooltipComponent> map = new HashMap<TooltipInfo.Icon, ClientTooltipComponent>();
            map.put(TooltipInfo.Icon.HEALTH, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)String.valueOf((int)entity.m_21223_())).m_7532_()));
            if (entity.m_21230_() > 0) {
                map.put(TooltipInfo.Icon.ARMOR, ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)String.valueOf(entity.m_21230_())).m_7532_()));
            }
            tooltipList.add(new TooltipInfo.MobInfo(map));
            InfoOverlay.setComponent(tooltipList);
        } else {
            name = InfoOverlay.hitResult;
            if (name instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)name;
                if (InfoOverlay.CLIENT.f_91074_ != null) {
                    BlockState state = InfoOverlay.CLIENT.f_91074_.m_9236_().m_8055_(blockHit.m_82425_());
                    String displayStr = state.m_60734_().m_49954_().getString();
                    String[] arr = displayStr.split(" +");
                    if (arr.length > 1) {
                        int maxLength = Minecraft.m_91087_().m_91268_().m_85445_() / 5;
                        StringBuilder str = new StringBuilder();
                        for (String addStr : arr) {
                            if (ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)(str + " " + addStr)).m_7532_()).m_142069_(InfoOverlay.CLIENT.f_91062_) > maxLength && !str.isEmpty()) {
                                tooltipList.add(new TooltipInfo.BlockInfo(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)str.toString()).m_7532_())));
                                str = new StringBuilder();
                            }
                            if (!str.isEmpty()) {
                                str.append(" ");
                            }
                            str.append(addStr);
                        }
                        tooltipList.add(new TooltipInfo.BlockInfo(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)str.toString()).m_7532_())));
                    } else {
                        tooltipList.add(new TooltipInfo.BlockInfo(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)displayStr).m_7532_())));
                    }
                    InfoOverlay.setComponent(tooltipList);
                }
            }
        }
    }

    public static int getLongest(List<TooltipInfo> list) {
        int result = 0;
        for (TooltipInfo tooltip : list) {
            result = Math.max(tooltip.getWidth(), result);
        }
        return result;
    }

    public static ChatFormatting getColor(LivingEntity entity) {
        if (entity instanceof Player) {
            return ChatFormatting.BLUE;
        }
        if (entity instanceof NeutralMob) {
            return ChatFormatting.YELLOW;
        }
        if (entity.m_6095_().m_20674_().m_21609_()) {
            return ChatFormatting.GREEN;
        }
        if (entity.m_6095_().m_20674_() == MobCategory.MONSTER) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.WHITE;
    }
}

