/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type.lostsouls.minotaurmaze;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.type.lostsouls.minotaurmaze.MinotaurMazePieceUp;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ConfigurableSpawns;
import twilightforest.world.components.structures.util.ConquerableStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class MinotaurMazeStructure
extends ConquerableStructure
implements ConfigurableSpawns {
    public static final Codec<MinotaurMazeStructure> CODEC = RecordCodecBuilder.create(instance -> MinotaurMazeStructure.conquerStatusCodec(instance).apply((Applicative)instance, MinotaurMazeStructure::new));

    public MinotaurMazeStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(controlledSpawningConfig, advancementLockConfig, hintConfig, decorationConfig, structureSettings);
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        int sizeX = 44;
        int sizeY = 42;
        BlockPos initialSpawnPos = new BlockPos(x - sizeX / 2, y - 4 - 12 - 1, z - sizeY / 2);
        return new MinotaurMazePieceUp(context.f_226625_(), initialSpawnPos);
    }

    @Override
    public ControlledSpawns.ControlledSpawningConfig getConfig() {
        return this.controlledSpawningConfig;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TFStructureTypes.LABYRINTH.get();
    }

    public static MinotaurMazeStructure buildLabyrinthConfig(BootstapContext<Structure> context) {
        return new MinotaurMazeStructure(ControlledSpawns.ControlledSpawningConfig.firstIndexMonsters(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.MINOTAUR.get(), 20, 2, 3), new MobSpawnSettings.SpawnerData(EntityType.f_20554_, 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.MAZE_SLIME.get(), 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 1, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.FIRE_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SLIME_BEETLE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.PINCH_BEETLE.get(), 10, 1, 1)), new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_lich"))), new StructureHints.HintConfig(StructureHints.HintConfig.book("labyrinth", 5), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(4, true, false, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_LABYRINTH_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_()))), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY));
    }
}

