/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type.lostsouls.darktower;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.type.lostsouls.darktower.DarkTowerPiece;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ConquerableStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class DarkTowerStructure
extends ConquerableStructure {
    public static final Codec<DarkTowerStructure> CODEC = RecordCodecBuilder.create(instance -> DarkTowerStructure.conquerStatusCodec(instance).apply((Applicative)instance, DarkTowerStructure::new));

    public DarkTowerStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(controlledSpawningConfig, advancementLockConfig, hintConfig, decorationConfig, structureSettings);
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        int sizeX = 117;
        int sizeY = 128;
        BlockPos initialSpawnPos = new BlockPos(x - sizeX / 2 - 10, y + 1, z - sizeY / 2 - 10);
        return new DarkTowerPiece(context.f_226625_(), initialSpawnPos);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TFStructureTypes.DARK_TOWER.get();
    }

    public static DarkTowerStructure buildDarkTowerConfig(BootstapContext<Structure> context) {
        return new DarkTowerStructure(ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.CARMINITE_GOLEM.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 10, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 5, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 2, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 1, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.CARMINITE_GHASTLING.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.CARMINITE_BROODLING.get(), 10, 4, 4), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.PINCH_BEETLE.get(), 10, 1, 1)), List.of(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.CARMINITE_GHASTGUARD.get(), 10, 1, 2))), List.of(), List.of(new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 10, 4, 4))), new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_knights"))), new StructureHints.HintConfig(StructureHints.HintConfig.book("darktower", 3), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(1, false, true, true), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_DARK_TOWER_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN));
    }
}

