/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type.lostsouls.darktower;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;

public class DarkTowerPiece
extends TwilightTemplateStructurePiece {
    private final Set<BlockPos> chestPositions = new HashSet<BlockPos>();

    public DarkTowerPiece(StructureTemplateManager structureManager, BlockPos startPosition) {
        super((StructurePieceType)TFStructurePieceTypes.LSDarkTower.get(), 0, structureManager, TwilightForestMod.lsPrefix("foxtower"), new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE), startPosition);
    }

    public DarkTowerPiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.LSDarkTower.get(), compoundTag, structurePieceSerializationContext, new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE));
    }

    public void m_213694_(WorldGenLevel pLevel, StructureManager pStructureManager, ChunkGenerator pGenerator, RandomSource pRandom, BoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
        super.m_213694_(pLevel, pStructureManager, pGenerator, pRandom, pBox, pChunkPos, pPos);
        for (StructureTemplate.StructureBlockInfo blockInfo : this.m_226911_().m_74603_(this.f_73658_, this.f_73657_, Blocks.f_50087_)) {
            this.chestPositions.add(blockInfo.f_74675_());
        }
        this.processChests(pLevel);
    }

    public void processChests(WorldGenLevel pLevel) {
        for (BlockPos pos : this.chestPositions) {
            BlockEntity blockEntity = pLevel.m_7702_(pos);
            if (!(blockEntity instanceof RandomizableContainerBlockEntity)) continue;
            RandomizableContainerBlockEntity randomizableContainerBlockEntity = (RandomizableContainerBlockEntity)blockEntity;
            randomizableContainerBlockEntity.m_6211_();
            CompoundTag nbtData = randomizableContainerBlockEntity.m_187480_();
            if (nbtData.m_128441_("LootTable")) {
                ResourceLocation lootTable = new ResourceLocation(nbtData.m_128461_("LootTable"));
                randomizableContainerBlockEntity.m_59626_(lootTable, pLevel.m_213780_().m_188505_());
                continue;
            }
            randomizableContainerBlockEntity.m_59626_(TFLootTables.DARKTOWER_CACHE.lootTable, pLevel.m_213780_().m_188505_());
        }
    }

    protected void m_213704_(String pName, BlockPos blockPos, ServerLevelAccessor serverLevelAccessor, RandomSource randomSource, BoundingBox boundingBox) {
    }
}

