/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type.lostsouls.aurorapalace;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.type.lostsouls.aurorapalace.AuroraPalacePiece;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ConquerableStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class AuroraPalaceStructure
extends ConquerableStructure {
    public static final Codec<AuroraPalaceStructure> CODEC = RecordCodecBuilder.create(instance -> AuroraPalaceStructure.conquerStatusCodec(instance).apply((Applicative)instance, AuroraPalaceStructure::new));

    public AuroraPalaceStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(controlledSpawningConfig, advancementLockConfig, hintConfig, decorationConfig, structureSettings);
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        int sizeX = 77;
        int sizeY = 95;
        BlockPos initialSpawnPos = new BlockPos(x - sizeX / 2, y + 25, z - sizeY / 2);
        return new AuroraPalacePiece(context.f_226625_(), initialSpawnPos);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TFStructureTypes.AURORA_PALACE.get();
    }

    public static AuroraPalaceStructure buildAuroraPalaceConfig(BootstapContext<Structure> context) {
        return new AuroraPalaceStructure(ControlledSpawns.ControlledSpawningConfig.firstIndexMonsters(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SNOW_GUARDIAN.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.STABLE_ICE_CORE.get(), 10, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TFEntities.UNSTABLE_ICE_CORE.get(), 5, 1, 2)), new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_yeti"))), new StructureHints.HintConfig(StructureHints.HintConfig.book("icetower", 3), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(3, false, true, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_AURORA_PALACE_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BURY));
    }
}

