/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.client.sound.BossMusicPlayer;
import twilightforest.client.sound.FlyBossMusicPlayer;
import twilightforest.entity.etc.Animation_Flying_Monsters;
import twilightforest.entity.etc.Animation_Monsters;

public class MusicPacket {
    private final int entityID;
    private final boolean play;

    public MusicPacket(int entityID, boolean play) {
        this.entityID = entityID;
        this.play = play;
    }

    public static MusicPacket read(FriendlyByteBuf buf) {
        return new MusicPacket(buf.readInt(), buf.readBoolean());
    }

    public static void write(MusicPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityID);
        buf.writeBoolean(message.play);
    }

    public static class Handler {
        public static boolean onMessage(MusicPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
                if (entity instanceof Animation_Monsters) {
                    Animation_Monsters am = (Animation_Monsters)entity;
                    if (message.play) {
                        BossMusicPlayer.playBossMusic(am);
                    } else {
                        BossMusicPlayer.stopBossMusic(am);
                    }
                } else if (entity instanceof Animation_Flying_Monsters) {
                    Animation_Flying_Monsters afm = (Animation_Flying_Monsters)entity;
                    if (message.play) {
                        FlyBossMusicPlayer.playBossMusic(afm);
                    } else {
                        FlyBossMusicPlayer.stopBossMusic(afm);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

