/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;
import twilightforest.client.ISTER;
import twilightforest.data.tags.ItemTagGenerator;

public class KnightmetalShieldItem
extends ShieldItem {
    private static final UUID ARMOR_TOUGHNESS_UUID = UUID.fromString("a56ec6da-6a57-4f4d-9a3b-c1f8dc9353ec");
    private static final UUID MAX_HEALTH_UUID = UUID.fromString("c4f8d978-59b5-4a7a-8301-e8e675ed2a1d");
    private final float armorToughness;
    private final float maxHealth;

    public KnightmetalShieldItem(Item.Properties properties, float armorToughness, float maxHealth) {
        super(properties);
        this.armorToughness = armorToughness;
        this.maxHealth = maxHealth;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(ItemTagGenerator.KNIGHTMETAL_INGOTS) || !repair.m_204117_(ItemTags.f_13168_) && super.m_6832_(toRepair, repair);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.OFFHAND || slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Multimap baseModifiers = super.m_7167_(slot);
            builder.putAll(baseModifiers);
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_TOUGHNESS_UUID, "Armor Toughness", (double)this.armorToughness, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(MAX_HEALTH_UUID, "Max Health", (double)this.maxHealth, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return ImmutableMultimap.of();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction) || super.canPerformAction(stack, toolAction);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ISTER.CLIENT_ITEM_EXTENSION);
    }
}

