/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enums;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;

public enum TwilightArmorMaterial implements ArmorMaterial
{
    ARMOR_NAGA("naga_scale", 21, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 7);
        map.put(ArmorItem.Type.HELMET, 2);
    }), 15, SoundEvents.f_11675_, 0.5f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.NAGA_SCALE.get()})),
    ARMOR_IRONWOOD("ironwood", 20, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 5);
        map.put(ArmorItem.Type.CHESTPLATE, 7);
        map.put(ArmorItem.Type.HELMET, 2);
    }), 15, SoundEvents.f_11675_, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.IRONWOOD_INGOT.get()})),
    ARMOR_FIERY("fiery", 25, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 4);
        map.put(ArmorItem.Type.LEGGINGS, 7);
        map.put(ArmorItem.Type.CHESTPLATE, 9);
        map.put(ArmorItem.Type.HELMET, 4);
    }), 10, SoundEvents.f_11675_, 1.5f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.FIERY_INGOT.get()})),
    ARMOR_STEELEAF("steeleaf", 10, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 9, SoundEvents.f_11675_, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.STEELEAF_INGOT.get()})),
    ARMOR_KNIGHTLY("knightly", 20, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 8, (SoundEvent)TFSounds.KNIGHTMETAL_EQUIP.get(), 1.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.KNIGHTMETAL_INGOT.get()})),
    ARMOR_PHANTOM("phantom", 30, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 8, SoundEvents.f_11675_, 2.5f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.KNIGHTMETAL_INGOT.get()})),
    ARMOR_YETI("yetiarmor", 20, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 7);
        map.put(ArmorItem.Type.HELMET, 4);
    }), 15, SoundEvents.f_11675_, 3.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFItems.ALPHA_YETI_FUR.get()}));

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durability;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final float toughness;
    private final Supplier<Ingredient> repairMaterial;

    private TwilightArmorMaterial(String name, int durability, EnumMap<ArmorItem.Type, Integer> protectionFunctionForType, int enchantability, SoundEvent sound, float toughness, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.durability = durability;
        this.protectionFunctionForType = protectionFunctionForType;
        this.enchantability = enchantability;
        this.equipSound = sound;
        this.toughness = toughness;
        this.repairMaterial = repairMaterial;
    }

    public String m_6082_() {
        return this.name;
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durability;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public Ingredient m_6230_() {
        return this.repairMaterial.get();
    }

    public float m_6649_() {
        return 0.0f;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 13);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

