/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import twilightforest.entity.Chain;
import twilightforest.entity.monster.BlockChainGoblin;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFSounds;
import twilightforest.util.WorldUtil;

public class ChainBlock
extends ThrowableProjectile
implements IEntityAdditionalSpawnData {
    private static final int MAX_SMASH = 12;
    private static final int MAX_CHAIN = 16;
    private static final EntityDataAccessor<Boolean> HAND = SynchedEntityData.m_135353_(ChainBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FOIL = SynchedEntityData.m_135353_(ChainBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isReturning = false;
    private boolean canSmashBlocks;
    private boolean hitEntity = false;
    private ItemStack stack;
    private int blocksSmashed = 0;
    private double velX;
    private double velY;
    private double velZ;
    public final Chain chain1;
    public final Chain chain2;
    public final Chain chain3;
    public final Chain chain4;
    public final Chain chain5;
    private final BlockChainGoblin.MultipartGenericsAreDumb[] partsArray;

    public ChainBlock(EntityType<? extends ChainBlock> type, Level world) {
        super(type, world);
        this.chain1 = new Chain((Entity)this);
        this.chain2 = new Chain((Entity)this);
        this.chain3 = new Chain((Entity)this);
        this.chain4 = new Chain((Entity)this);
        this.chain5 = new Chain((Entity)this);
        this.partsArray = new BlockChainGoblin.MultipartGenericsAreDumb[]{this.chain1, this.chain2, this.chain3, this.chain4, this.chain5};
    }

    public ChainBlock(EntityType<? extends ChainBlock> type, Level world, LivingEntity thrower, InteractionHand hand, ItemStack stack) {
        super(type, thrower, world);
        this.isReturning = false;
        this.canSmashBlocks = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)TFEnchantments.DESTRUCTION.get()), (ItemStack)stack) > 0 && !thrower.m_21023_(MobEffects.f_19599_);
        this.stack = stack;
        this.setHand(hand);
        this.chain1 = new Chain((Entity)this);
        this.chain2 = new Chain((Entity)this);
        this.chain3 = new Chain((Entity)this);
        this.chain4 = new Chain((Entity)this);
        this.chain5 = new Chain((Entity)this);
        this.partsArray = new BlockChainGoblin.MultipartGenericsAreDumb[]{this.chain1, this.chain2, this.chain3, this.chain4, this.chain5};
        this.m_37251_((Entity)thrower, thrower.m_146909_(), thrower.m_146908_(), 0.0f, 1.5f, 1.0f);
        this.m_20088_().m_135381_(IS_FOIL, (Object)stack.m_41790_());
    }

    private void setHand(InteractionHand hand) {
        this.m_20088_().m_135381_(HAND, (Object)(hand == InteractionHand.MAIN_HAND ? 1 : 0));
    }

    public InteractionHand getHand() {
        return (Boolean)this.m_20088_().m_135370_(HAND) != false ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public boolean isFoil() {
        return (Boolean)this.m_20088_().m_135370_(IS_FOIL);
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6686_(double x, double y, double z, float speed, float accuracy) {
        super.m_6686_(x, y, z, speed, accuracy);
        this.velX = this.m_20184_().m_7096_();
        this.velY = this.m_20184_().m_7098_();
        this.velZ = this.m_20184_().m_7094_();
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().m_5776_() && result.m_82443_() != this.m_19749_()) {
            Player player;
            LivingEntity living;
            float damage = 0.0f;
            Entity entity = result.m_82443_();
            if (entity instanceof LivingEntity) {
                living = (LivingEntity)entity;
                damage = 10.0f + EnchantmentHelper.m_44833_((ItemStack)this.stack, (MobType)living.m_6336_());
            } else {
                PartEntity part;
                entity = result.m_82443_();
                if (entity instanceof PartEntity && (entity = (part = (PartEntity)entity).getParent()) instanceof LivingEntity) {
                    LivingEntity living2 = (LivingEntity)entity;
                    damage = 10.0f + EnchantmentHelper.m_44833_((ItemStack)this.stack, (MobType)living2.m_6336_());
                }
            }
            Entity entity2 = result.m_82443_();
            if (entity2 instanceof Player && (player = (Player)entity2).m_6117_() && player.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
                player.m_21211_().m_41622_(5, (LivingEntity)player, event -> event.m_21190_(player.m_7655_()));
                player.m_36384_(true);
            }
            if (damage > 0.0f && result.m_82443_().m_6469_(TFDamageTypes.getIndirectEntityDamageSource(this.m_9236_(), TFDamageTypes.SPIKED, (Entity)this, this.m_19749_(), new EntityType[0]), damage)) {
                this.m_5496_((SoundEvent)TFSounds.BLOCK_AND_CHAIN_HIT.get(), 1.0f, this.f_19796_.m_188501_());
                this.hitEntity = true;
                this.isReturning = true;
                this.f_19797_ += 60;
                entity2 = this.m_19749_();
                if (entity2 instanceof LivingEntity) {
                    living = (LivingEntity)entity2;
                    this.stack.m_41622_(1, living, user -> user.m_21190_(this.getHand()));
                }
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().m_5776_() && !this.m_9236_().m_46859_(result.m_82425_())) {
            if (!this.stack.m_41735_(this.m_9236_().m_8055_(result.m_82425_()))) {
                if (!this.isReturning && !this.hitEntity) {
                    this.m_5496_((SoundEvent)TFSounds.BLOCK_AND_CHAIN_COLLIDE.get(), 0.125f, this.f_19796_.m_188501_());
                    this.m_146850_(GameEvent.f_157770_);
                }
                this.isReturning = true;
                double bounce = 0.6;
                this.velX *= bounce;
                this.velY *= bounce;
                this.velZ *= bounce;
                switch (result.m_82434_()) {
                    case DOWN: {
                        if (!(this.velY > 0.0)) break;
                        this.velY *= -bounce;
                        break;
                    }
                    case UP: {
                        if (!(this.velY < 0.0)) break;
                        this.velY *= -bounce;
                        break;
                    }
                    case NORTH: {
                        if (!(this.velZ > 0.0)) break;
                        this.velZ *= -bounce;
                        break;
                    }
                    case SOUTH: {
                        if (!(this.velZ < 0.0)) break;
                        this.velZ *= -bounce;
                        break;
                    }
                    case WEST: {
                        if (!(this.velX > 0.0)) break;
                        this.velX *= -bounce;
                        break;
                    }
                    case EAST: {
                        if (!(this.velX < 0.0)) break;
                        this.velX *= -bounce;
                    }
                }
            }
            if (this.canSmashBlocks) {
                AABB aabb = this.m_20191_().m_82400_(0.25);
                this.affectBlocksInAABB(aabb.m_82383_(result.m_82450_().m_82546_(aabb.m_82399_()).m_82520_(-0.5, 0.0, 0.0)));
            }
        }
        if (this.blocksSmashed > 12) {
            this.isReturning = true;
            if (this.f_19797_ < 60) {
                this.f_19797_ += 60;
            }
        }
    }

    private void affectBlocksInAABB(AABB box) {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean creative = player.m_150110_().f_35937_;
            for (BlockPos pos : WorldUtil.getAllInBB(box)) {
                BlockState state = this.m_9236_().m_8055_(pos);
                Block block = state.m_60734_();
                if (state.m_60795_() || !this.stack.m_41735_(state) || !block.canEntityDestroy(state, (BlockGetter)this.m_9236_(), pos, (Entity)this) || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.m_9236_(), pos, state, player)) || !ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)state, (!state.m_60834_() || player.m_21120_(this.getHand()).m_41735_(state) ? 1 : 0) != 0)) continue;
                this.m_9236_().m_46961_(pos, false);
                if (!creative) {
                    block.m_6240_(this.m_9236_(), player, pos, state, this.m_9236_().m_7702_(pos), player.m_21120_(this.getHand()));
                }
                ++this.blocksSmashed;
                if (this.blocksSmashed <= 12) continue;
                break;
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.chain1.m_8119_();
            this.chain2.m_8119_();
            this.chain3.m_8119_();
            this.chain4.m_8119_();
            this.chain5.m_8119_();
            if (this.m_19749_() != null) {
                Vec3 handVec = this.m_19749_().m_20154_().m_82524_(this.getHand() == InteractionHand.MAIN_HAND ? -0.4f : 0.4f);
                double sx = this.m_19749_().m_20185_() + handVec.m_7096_();
                double sy = this.m_19749_().m_20186_() + handVec.m_7098_() - (double)0.4f + (double)this.m_19749_().m_20192_();
                double sz = this.m_19749_().m_20189_() + handVec.m_7094_();
                double ox = sx - this.m_20185_();
                double oy = sy - this.m_20186_() - 0.25;
                double oz = sz - this.m_20189_();
                this.chain1.m_6034_(sx - ox * 0.05, sy - oy * 0.05, sz - oz * 0.05);
                this.chain2.m_6034_(sx - ox * 0.25, sy - oy * 0.25, sz - oz * 0.25);
                this.chain3.m_6034_(sx - ox * 0.45, sy - oy * 0.45, sz - oz * 0.45);
                this.chain4.m_6034_(sx - ox * 0.65, sy - oy * 0.65, sz - oz * 0.65);
                this.chain5.m_6034_(sx - ox * 0.85, sy - oy * 0.85, sz - oz * 0.85);
            }
        } else if (this.m_19749_() == null) {
            this.m_146870_();
        } else {
            double distToPlayer = this.m_20270_(this.m_19749_());
            if (!this.isReturning && distToPlayer > 16.0) {
                this.isReturning = true;
            }
            if (this.isReturning) {
                if (distToPlayer < 2.0) {
                    Entity sy = this.m_19749_();
                    if (sy instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)sy;
                        if (this.blocksSmashed > 0) {
                            this.stack.m_41622_(Math.min(this.blocksSmashed, 3), living, user -> user.m_21190_(this.getHand()));
                        }
                    }
                    this.m_146870_();
                }
                LivingEntity returnTo = (LivingEntity)this.m_19749_();
                Vec3 back = new Vec3(returnTo.m_20185_(), returnTo.m_20186_() + (double)returnTo.m_20192_(), returnTo.m_20189_()).m_82546_(this.m_20182_()).m_82541_();
                float age = Math.min((float)this.f_19797_ * 0.03f, 1.0f);
                this.m_20256_(new Vec3(this.velX * (1.0 - (double)age) + back.m_7096_() * 2.0 * (double)age, this.velY * (1.0 - (double)age) + back.m_7098_() * 2.0 * (double)age - (double)this.m_7139_(), this.velZ * (1.0 - (double)age) + back.m_7094_() * 2.0 * (double)age));
            }
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(HAND, (Object)true);
        this.m_20088_().m_135372_(IS_FOIL, (Object)false);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        LivingEntity thrower = (LivingEntity)this.m_19749_();
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("BlockAndChainStack", 10)) {
            this.stack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("BlockAndChainStack"));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("BlockAndChainStack", (Tag)this.stack.m_41739_(new CompoundTag()));
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.m_19749_() != null ? this.m_19749_().m_19879_() : -1);
        buffer.writeBoolean(this.getHand() == InteractionHand.MAIN_HAND);
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        Entity e = this.m_9236_().m_6815_(buf.readInt());
        if (e instanceof LivingEntity) {
            this.m_5602_(e);
        }
        this.setHand(buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }
}

