/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei;

import java.util.Collections;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import twilightforest.TwilightForestMod;
import twilightforest.compat.jei.FakeItemEntity;
import twilightforest.compat.jei.categories.CrumbleHornCategory;
import twilightforest.compat.jei.categories.TransformationPowderCategory;
import twilightforest.compat.jei.renderers.EntityHelper;
import twilightforest.compat.jei.renderers.EntityRenderer;
import twilightforest.compat.jei.renderers.FakeItemEntityHelper;
import twilightforest.compat.jei.renderers.FakeItemEntityRenderer;
import twilightforest.init.TFItems;
import twilightforest.init.TFRecipes;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final IIngredientType<EntityType> ENTITY_TYPE = () -> EntityType.class;
    public static final IIngredientType<FakeItemEntity> FAKE_ITEM_ENTITY = () -> FakeItemEntity.class;

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFItems.TRANSFORMATION_POWDER.get()), new RecipeType[]{TransformationPowderCategory.TRANSFORMATION});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TFItems.CRUMBLE_HORN.get()), new RecipeType[]{CrumbleHornCategory.CRUMBLE_HORN});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ENTITY_TYPE, Collections.emptyList(), (IIngredientHelper)new EntityHelper(), (IIngredientRenderer)new EntityRenderer(16));
        registration.register(FAKE_ITEM_ENTITY, Collections.emptyList(), (IIngredientHelper)new FakeItemEntityHelper(), (IIngredientRenderer)new FakeItemEntityRenderer(16));
    }

    public ResourceLocation getPluginUid() {
        return TwilightForestMod.prefix("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new TransformationPowderCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrumbleHornCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        registration.addRecipes(TransformationPowderCategory.TRANSFORMATION, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TFRecipes.TRANSFORM_POWDER_RECIPE.get()));
        registration.addRecipes(CrumbleHornCategory.CRUMBLE_HORN, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TFRecipes.CRUMBLE_RECIPE.get()));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }
}

