/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.TFHorizontalBlock;
import twilightforest.block.entity.KeepsakeCasketBlockEntity;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.init.TFBlockEntities;

public class KeepsakeCasketBlock
extends BaseEntityBlock
implements BlockLoggingEnum.IMultiLoggable {
    public static final DirectionProperty FACING = TFHorizontalBlock.f_54117_;
    public static final IntegerProperty BREAKAGE = IntegerProperty.m_61631_((String)"damage", (int)0, (int)2);
    private static final VoxelShape BOTTOM_X = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)6.0, (double)15.0);
    private static final VoxelShape TOP_X = Block.m_49796_((double)1.0, (double)6.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape BOTTOM_Z = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)6.0, (double)14.0);
    private static final VoxelShape TOP_Z = Block.m_49796_((double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    private static final VoxelShape CASKET_X = Shapes.m_83110_((VoxelShape)BOTTOM_X, (VoxelShape)TOP_X);
    private static final VoxelShape CASKET_Z = Shapes.m_83110_((VoxelShape)BOTTOM_Z, (VoxelShape)TOP_Z);
    private static final VoxelShape SOLID = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape TOPPER_X = Block.m_49796_((double)1.0, (double)12.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape TOPPER_Z = Block.m_49796_((double)0.0, (double)12.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    private static final VoxelShape SOLID_X = Shapes.m_83110_((VoxelShape)SOLID, (VoxelShape)TOPPER_X);
    private static final VoxelShape SOLID_Z = Shapes.m_83110_((VoxelShape)SOLID, (VoxelShape)TOPPER_Z);

    public KeepsakeCasketBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BREAKAGE, (Comparable)Integer.valueOf(0)));
    }

    public RenderShape m_7514_(BlockState state) {
        return ((BlockLoggingEnum)((Object)state.m_61143_(BlockLoggingEnum.MULTILOGGED))).getBlock() == Blocks.f_50016_ ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (((BlockLoggingEnum)((Object)state.m_61143_(BlockLoggingEnum.MULTILOGGED))).getBlock() != Blocks.f_50016_ && ((BlockLoggingEnum)((Object)state.m_61143_(BlockLoggingEnum.MULTILOGGED))).getFluid() == Fluids.f_76191_) {
            return direction.m_122434_() == Direction.Axis.X ? SOLID_X : SOLID_Z;
        }
        return direction.m_122434_() == Direction.Axis.X ? CASKET_X : CASKET_Z;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeepsakeCasketBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return KeepsakeCasketBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.KEEPSAKE_CASKET.get()), KeepsakeCasketBlockEntity::tick);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = level.m_7702_(pos);
            if (tileentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)tileentity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter getter, BlockPos pos, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean flag = false;
        if (((BlockLoggingEnum)((Object)state.m_61143_(BlockLoggingEnum.MULTILOGGED))).getBlock() == Blocks.f_50016_ || ((BlockLoggingEnum)((Object)state.m_61143_(BlockLoggingEnum.MULTILOGGED))).getFluid() != Fluids.f_76191_) {
            ItemStack itemStack = player.m_21120_(hand);
        }
        return flag ? InteractionResult.m_19078_((boolean)level.m_5776_()) : InteractionResult.PASS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity tile;
        if (!level.m_5776_() && !player.m_7500_() && level.m_46469_().m_46207_(GameRules.f_46136_) && (tile = level.m_7702_(pos)) instanceof KeepsakeCasketBlockEntity) {
            Block block;
            KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)tile;
            ItemStack stack = new ItemStack((ItemLike)this);
            String nameCheck = Component.m_237113_((String)(casket.name + "'s " + casket.m_5446_())).getString();
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("damage", ((Integer)state.m_61143_((Property)BREAKAGE)).intValue());
            stack.m_41700_("BlockStateTag", (Tag)nbt);
            if (casket.m_8077_()) {
                if (nameCheck.equals(casket.m_7770_().getString())) {
                    itementity.m_6593_(casket.m_5446_());
                } else {
                    itementity.m_6593_(casket.m_7770_());
                }
            }
            if (((BlockLoggingEnum)((Object)state.m_61143_(BlockLoggingEnum.MULTILOGGED))).getFluid() == Fluids.f_76191_ && (block = ((BlockLoggingEnum)((Object)state.m_61143_(BlockLoggingEnum.MULTILOGGED))).getBlock()) != Blocks.f_50016_) {
                ItemStack blockstack = new ItemStack((ItemLike)block);
                ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), blockstack);
                item.m_32060_();
                level.m_7967_((Entity)item);
            }
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        CompoundTag damageNbt;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("BlockStateTag") && (damageNbt = nbt.m_128469_("BlockStateTag")).m_128441_("damage")) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BREAKAGE, (Comparable)Integer.valueOf(damageNbt.m_128451_("damage"))), 2);
        }
        if (stack.m_41788_() && (tileentity = level.m_7702_(pos)) instanceof KeepsakeCasketBlockEntity) {
            ((KeepsakeCasketBlockEntity)tileentity).m_58638_(stack.m_41786_());
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.reactWithNeighbors(level, pos, state);
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    private void reactWithNeighbors(Level level, BlockPos pos, BlockState state) {
        block4: {
            block3: {
                if (state.m_61143_(BlockLoggingEnum.MULTILOGGED) != BlockLoggingEnum.LAVA) break block3;
                boolean flag = level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50136_);
                for (Direction direction : Direction.values()) {
                    if (direction == Direction.DOWN) continue;
                    BlockPos blockpos = pos.m_121945_(direction);
                    if (level.m_6425_(blockpos).m_205070_(FluidTags.f_13131_)) {
                        level.m_46597_(pos, (BlockState)state.m_61124_(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.OBSIDIAN)));
                        level.m_46796_(1501, pos, 0);
                    }
                    if (!flag || !level.m_8055_(blockpos).m_60713_(Blocks.f_50568_)) continue;
                    level.m_46597_(pos, (BlockState)state.m_61124_(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.BASALT)));
                    level.m_46796_(1501, pos, 0);
                }
                break block4;
            }
            if (state.m_61143_(BlockLoggingEnum.MULTILOGGED) != BlockLoggingEnum.WATER) break block4;
            for (Direction direction : Direction.values()) {
                BlockPos blockpos;
                if (direction == Direction.DOWN || !level.m_6425_(blockpos = pos.m_121945_(direction)).m_205070_(FluidTags.f_13132_)) continue;
                level.m_46597_(pos, (BlockState)state.m_61124_(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.STONE)));
                level.m_46796_(1501, pos, 0);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockLoggingEnum.MULTILOGGED, FACING, BREAKAGE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(context.m_43725_().m_6425_(context.m_8083_()).m_76152_())));
    }

    public FluidState m_5888_(BlockState state) {
        return ((BlockLoggingEnum)((Object)state.m_61143_(BlockLoggingEnum.MULTILOGGED))).getFluid().m_76145_();
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static DoubleBlockCombiner.Combiner<KeepsakeCasketBlockEntity, Float2FloatFunction> getLidRotationCallback(final LidBlockEntity lid) {
        return new DoubleBlockCombiner.Combiner<KeepsakeCasketBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction acceptDouble(KeepsakeCasketBlockEntity casket, KeepsakeCasketBlockEntity oldCasket) {
                return angle -> Math.max(casket.m_6683_(angle), oldCasket.m_6683_(angle));
            }

            public Float2FloatFunction acceptSingle(KeepsakeCasketBlockEntity casket) {
                return casket::m_6683_;
            }

            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)lid).m_6683_(arg_0);
            }
        };
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.empty();
    }
}

