/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.Bindings;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.capabilities.CapabilityList;
import twilightforest.client.ClientInitiator;
import twilightforest.command.TFCommand;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.compat.top.TopCompat;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.dispenser.TFDispenserBehaviors;
import twilightforest.init.TFBannerPatterns;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFCreativeTabs;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFEntities;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.init.TFFeatures;
import twilightforest.init.TFItems;
import twilightforest.init.TFLoot;
import twilightforest.init.TFLootModifiers;
import twilightforest.init.TFMenuTypes;
import twilightforest.init.TFMobEffects;
import twilightforest.init.TFPOITypes;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFRecipes;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.init.TFStructureProcessors;
import twilightforest.init.TFStructureTypes;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.init.custom.DwarfRabbitVariant;
import twilightforest.init.custom.Enforcement;
import twilightforest.init.custom.MagicPaintingVariants;
import twilightforest.init.custom.Restrictions;
import twilightforest.init.custom.TinyBirdVariant;
import twilightforest.init.custom.WoodPalettes;
import twilightforest.item.recipe.UncraftingTableCondition;
import twilightforest.loot.modifiers.GiantToolGroupingModifier;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateGamerulePacket;
import twilightforest.util.MagicPaintingVariant;
import twilightforest.util.Restriction;
import twilightforest.util.WoodPalette;
import twilightforest.world.components.BiomeGrassColors;
import twilightforest.world.components.biomesources.LandmarkBiomeSource;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.chunkgenerators.ControlledSpawnsCache;

@Mod(value="twilightforest")
public class TwilightForestMod {
    public static final String ID = "twilightforest";
    public static final String REGISTRY_NAMESPACE = "twilight";
    private static final String MODEL_DIR = "textures/model/";
    private static final String GUI_DIR = "textures/gui/";
    private static final String ENVIRO_DIR = "textures/environment/";
    public static final String ARMOR_DIR = "twilightforest:textures/armor/";
    public static final GameRules.Key<GameRules.BooleanValue> ENFORCED_PROGRESSION_RULE = GameRules.m_46189_((String)"tfEnforcedProgression", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.BooleanValue.m_46252_((boolean)true, (server, enforced) -> TFPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateGamerulePacket(enforced.m_46223_()))));
    public static final Logger LOGGER = LogManager.getLogger((String)"twilightforest");
    private static final Rarity rarity = Rarity.create((String)"TWILIGHT", (ChatFormatting)ChatFormatting.DARK_GREEN);

    public TwilightForestMod() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TFConfig.Common::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        TFConfig.COMMON_CONFIG = (TFConfig.Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(TFConfig.Client::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
        TFConfig.CLIENT_CONFIG = (TFConfig.Client)specPair.getLeft();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientInitiator::call);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, CapabilityList::attachLevelCapability);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityList::attachEntityCapability);
        MinecraftForge.EVENT_BUS.addListener(Stalactite::reloadStalactites);
        MinecraftForge.EVENT_BUS.addListener(ControlledSpawnsCache::reload);
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        TFBannerPatterns.BANNER_PATTERNS.register(modbus);
        TFBlockEntities.BLOCK_ENTITIES.register(modbus);
        TFBlocks.BLOCKS.register(modbus);
        TFLoot.CONDITIONS.register(modbus);
        TFMenuTypes.CONTAINERS.register(modbus);
        TFEnchantments.ENCHANTMENTS.register(modbus);
        TFEntities.ENTITIES.register(modbus);
        BiomeLayerTypes.BIOME_LAYER_TYPES.register(modbus);
        BiomeLayerStack.BIOME_LAYER_STACKS.register(modbus);
        TFFeatures.FEATURES.register(modbus);
        TFFeatureModifiers.FOLIAGE_PLACERS.register(modbus);
        TFLoot.FUNCTIONS.register(modbus);
        TFItems.ITEMS.register(modbus);
        TFLootModifiers.LOOT_MODIFIERS.register(modbus);
        TFMobEffects.MOB_EFFECTS.register(modbus);
        TFParticleType.PARTICLE_TYPES.register(modbus);
        TFPOITypes.POIS.register(modbus);
        TFFeatureModifiers.PLACEMENT_MODIFIERS.register(modbus);
        TFRecipes.RECIPE_SERIALIZERS.register(modbus);
        TFRecipes.RECIPE_TYPES.register(modbus);
        TFSounds.SOUNDS.register(modbus);
        TFEntities.SPAWN_EGGS.register(modbus);
        TFStats.STATS.register(modbus);
        TFStructurePieceTypes.STRUCTURE_PIECE_TYPES.register(modbus);
        TFStructureProcessors.STRUCTURE_PROCESSORS.register(modbus);
        TFStructurePlacementTypes.STRUCTURE_PLACEMENT_TYPES.register(modbus);
        TFStructureTypes.STRUCTURE_TYPES.register(modbus);
        TFCreativeTabs.TABS.register(modbus);
        TFFeatureModifiers.TREE_DECORATORS.register(modbus);
        TFFeatureModifiers.TRUNK_PLACERS.register(modbus);
        DwarfRabbitVariant.DWARF_RABBITS.register(modbus);
        TinyBirdVariant.TINY_BIRDS.register(modbus);
        WoodPalettes.WOOD_PALETTES.register(modbus);
        Enforcement.ENFORCEMENTS.register(modbus);
        Restrictions.RESTRICTIONS.register(modbus);
        MagicPaintingVariants.MAGIC_PAINTINGS.register(modbus);
        modbus.addListener(this::sendIMCs);
        modbus.addListener(this::init);
        modbus.addListener(this::registerExtraStuff);
        modbus.addListener(this::setRegistriesForDatapack);
        modbus.addListener(CapabilityList::registerCapabilities);
        if (ModList.get().isLoaded("curios")) {
            ((IEventBus)Bindings.getForgeBus().get()).addListener(CuriosCompat::keepCurios);
            modbus.addListener(CuriosCompat::registerCurioRenderers);
            modbus.addListener(CuriosCompat::registerCurioLayers);
        }
        BiomeGrassColors.init();
    }

    public void setRegistriesForDatapack(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(WoodPalettes.WOOD_PALETTE_TYPE_KEY, WoodPalette.CODEC);
        event.dataPackRegistry(BiomeLayerStack.BIOME_STACK_KEY, BiomeLayerStack.DISPATCH_CODEC);
        event.dataPackRegistry(Restrictions.RESTRICTION_KEY, Restriction.CODEC, Restriction.CODEC);
        event.dataPackRegistry(MagicPaintingVariants.REGISTRY_KEY, MagicPaintingVariant.CODEC, MagicPaintingVariant.CODEC);
    }

    public void registerExtraStuff(RegisterEvent evt) {
        if (evt.getRegistryKey().equals(Registries.f_256826_)) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_256737_, (ResourceLocation)TwilightForestMod.prefix("twilight_biomes"), TFBiomeProvider.TF_CODEC);
            Registry.m_122965_((Registry)BuiltInRegistries.f_256737_, (ResourceLocation)TwilightForestMod.prefix("landmarks"), LandmarkBiomeSource.CODEC);
        } else if (evt.getRegistryKey().equals(Registries.f_256783_)) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_256914_, (ResourceLocation)TwilightForestMod.prefix("structure_locating_wrapper"), ChunkGeneratorTwilight.CODEC);
        } else if (evt.getRegistryKey().equals(ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((IConditionSerializer)UncraftingTableCondition.Serializer.INSTANCE);
        }
    }

    public void sendIMCs(InterModEnqueueEvent evt) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopCompat::new);
        }
    }

    public void init(FMLCommonSetupEvent evt) {
        TFPacketHandler.init();
        TFAdvancements.init();
        evt.enqueueWork(() -> {
            TFSounds.registerParrotSounds();
            TFDispenserBehaviors.init();
            TFStats.init();
            AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
            AxeItem.f_150683_.put((Block)TFBlocks.TWILIGHT_OAK_LOG.get(), (Block)TFBlocks.STRIPPED_TWILIGHT_OAK_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.CANOPY_LOG.get(), (Block)TFBlocks.STRIPPED_CANOPY_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MANGROVE_LOG.get(), (Block)TFBlocks.STRIPPED_MANGROVE_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.DARK_LOG.get(), (Block)TFBlocks.STRIPPED_DARK_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TIME_LOG.get(), (Block)TFBlocks.STRIPPED_TIME_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TRANSFORMATION_LOG.get(), (Block)TFBlocks.STRIPPED_TRANSFORMATION_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MINING_LOG.get(), (Block)TFBlocks.STRIPPED_MINING_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.SORTING_LOG.get(), (Block)TFBlocks.STRIPPED_SORTING_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TWILIGHT_OAK_WOOD.get(), (Block)TFBlocks.STRIPPED_TWILIGHT_OAK_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.CANOPY_WOOD.get(), (Block)TFBlocks.STRIPPED_CANOPY_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MANGROVE_WOOD.get(), (Block)TFBlocks.STRIPPED_MANGROVE_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.DARK_WOOD.get(), (Block)TFBlocks.STRIPPED_DARK_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TIME_WOOD.get(), (Block)TFBlocks.STRIPPED_TIME_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TRANSFORMATION_WOOD.get(), (Block)TFBlocks.STRIPPED_TRANSFORMATION_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MINING_WOOD.get(), (Block)TFBlocks.STRIPPED_MINING_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.SORTING_WOOD.get(), (Block)TFBlocks.STRIPPED_SORTING_WOOD.get());
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.f_50276_;
            pot.addPlant(TFBlocks.TWILIGHT_OAK_SAPLING.getId(), TFBlocks.POTTED_TWILIGHT_OAK_SAPLING);
            pot.addPlant(TFBlocks.CANOPY_SAPLING.getId(), TFBlocks.POTTED_CANOPY_SAPLING);
            pot.addPlant(TFBlocks.MANGROVE_SAPLING.getId(), TFBlocks.POTTED_MANGROVE_SAPLING);
            pot.addPlant(TFBlocks.DARKWOOD_SAPLING.getId(), TFBlocks.POTTED_DARKWOOD_SAPLING);
            pot.addPlant(TFBlocks.HOLLOW_OAK_SAPLING.getId(), TFBlocks.POTTED_HOLLOW_OAK_SAPLING);
            pot.addPlant(TFBlocks.RAINBOW_OAK_SAPLING.getId(), TFBlocks.POTTED_RAINBOW_OAK_SAPLING);
            pot.addPlant(TFBlocks.TIME_SAPLING.getId(), TFBlocks.POTTED_TIME_SAPLING);
            pot.addPlant(TFBlocks.TRANSFORMATION_SAPLING.getId(), TFBlocks.POTTED_TRANSFORMATION_SAPLING);
            pot.addPlant(TFBlocks.MINING_SAPLING.getId(), TFBlocks.POTTED_MINING_SAPLING);
            pot.addPlant(TFBlocks.SORTING_SAPLING.getId(), TFBlocks.POTTED_SORTING_SAPLING);
            pot.addPlant(TFBlocks.MAYAPPLE.getId(), TFBlocks.POTTED_MAYAPPLE);
            pot.addPlant(TFBlocks.FIDDLEHEAD.getId(), TFBlocks.POTTED_FIDDLEHEAD);
            pot.addPlant(TFBlocks.MUSHGLOOM.getId(), TFBlocks.POTTED_MUSHGLOOM);
            pot.addPlant(TFBlocks.BROWN_THORNS.getId(), TFBlocks.POTTED_THORN);
            pot.addPlant(TFBlocks.GREEN_THORNS.getId(), TFBlocks.POTTED_GREEN_THORN);
            pot.addPlant(TFBlocks.BURNT_THORNS.getId(), TFBlocks.POTTED_DEAD_THORN);
            FireBlock fireblock = (FireBlock)Blocks.f_50083_;
            fireblock.m_53444_((Block)TFBlocks.ROOT_BLOCK.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.ARCTIC_FUR_BLOCK.get(), 20, 20);
            fireblock.m_53444_((Block)TFBlocks.LIVEROOT_BLOCK.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.EMPTY_CANOPY_BOOKSHELF.get(), 30, 20);
            fireblock.m_53444_((Block)TFBlocks.DEATH_TOME_SPAWNER.get(), 30, 20);
            fireblock.m_53444_((Block)TFBlocks.TWILIGHT_OAK_WOOD.get(), 5, 5);
            fireblock.m_53444_((Block)TFBlocks.TWILIGHT_OAK_PLANKS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TWILIGHT_OAK_SLAB.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TWILIGHT_OAK_STAIRS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TWILIGHT_OAK_FENCE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TWILIGHT_OAK_GATE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.CANOPY_WOOD.get(), 5, 5);
            fireblock.m_53444_((Block)TFBlocks.CANOPY_PLANKS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.CANOPY_SLAB.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.CANOPY_STAIRS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.CANOPY_FENCE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.CANOPY_GATE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.CANOPY_BOOKSHELF.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MANGROVE_WOOD.get(), 5, 5);
            fireblock.m_53444_((Block)TFBlocks.MANGROVE_PLANKS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MANGROVE_SLAB.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MANGROVE_STAIRS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MANGROVE_FENCE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MANGROVE_GATE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MANGROVE_ROOT.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.DARK_WOOD.get(), 5, 5);
            fireblock.m_53444_((Block)TFBlocks.DARK_PLANKS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.DARK_SLAB.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.DARK_STAIRS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.DARK_FENCE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.DARK_GATE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TIME_WOOD.get(), 5, 5);
            fireblock.m_53444_((Block)TFBlocks.TIME_PLANKS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TIME_SLAB.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TIME_STAIRS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TIME_FENCE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TIME_GATE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TRANSFORMATION_WOOD.get(), 5, 5);
            fireblock.m_53444_((Block)TFBlocks.TRANSFORMATION_PLANKS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TRANSFORMATION_SLAB.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TRANSFORMATION_STAIRS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TRANSFORMATION_FENCE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.TRANSFORMATION_GATE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MINING_WOOD.get(), 5, 5);
            fireblock.m_53444_((Block)TFBlocks.MINING_PLANKS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MINING_SLAB.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MINING_STAIRS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MINING_FENCE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.MINING_GATE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.SORTING_WOOD.get(), 5, 5);
            fireblock.m_53444_((Block)TFBlocks.SORTING_PLANKS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.SORTING_SLAB.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.SORTING_STAIRS.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.SORTING_FENCE.get(), 5, 20);
            fireblock.m_53444_((Block)TFBlocks.SORTING_GATE.get(), 5, 20);
            ComposterBlock.m_51920_((float)0.1f, (ItemLike)((ItemLike)TFBlocks.FALLEN_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.CANOPY_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.CLOVER_PATCH.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.DARK_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.FIDDLEHEAD.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.HEDGE.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.MANGROVE_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.MAYAPPLE.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.MINING_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.TWILIGHT_OAK_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.RAINBOW_OAK_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.ROOT_STRAND.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.SORTING_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.THORN_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.TIME_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.TRANSFORMATION_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.TWILIGHT_OAK_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.CANOPY_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.MANGROVE_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.DARKWOOD_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFBlocks.RAINBOW_OAK_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.BEANSTALK_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.MOSS_PATCH.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.ROOT_BLOCK.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.THORN_ROSE.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.TROLLVIDR.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.HOLLOW_OAK_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.TIME_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.TRANSFORMATION_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.MINING_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.SORTING_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFBlocks.TORCHBERRY_PLANT.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFBlocks.HUGE_MUSHGLOOM_STEM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFBlocks.HUGE_WATER_LILY.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFBlocks.LIVEROOT_BLOCK.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFBlocks.MUSHGLOOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFBlocks.UBEROUS_SOIL.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFBlocks.HUGE_STALK.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFBlocks.UNRIPE_TROLLBER.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFBlocks.TROLLBER.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)TFBlocks.HUGE_LILY_PAD.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)TFBlocks.HUGE_MUSHGLOOM.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)TFItems.TORCHBERRIES.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)TFItems.LIVEROOT.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)TFItems.MAZE_WAFER.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)TFItems.EXPERIMENT_115.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)TFItems.MAGIC_BEANS.get()));
            GiantToolGroupingModifier.CONVERSIONS.put(Blocks.f_50652_, ((Block)TFBlocks.GIANT_COBBLESTONE.get()).m_5456_());
            GiantToolGroupingModifier.CONVERSIONS.put(Blocks.f_49999_, ((Block)TFBlocks.GIANT_LOG.get()).m_5456_());
            GiantToolGroupingModifier.CONVERSIONS.put(Blocks.f_50050_, ((Block)TFBlocks.GIANT_LEAVES.get()).m_5456_());
            GiantToolGroupingModifier.CONVERSIONS.put(Blocks.f_50080_, ((Block)TFBlocks.GIANT_OBSIDIAN.get()).m_5456_());
        });
    }

    public void registerCommands(RegisterCommandsEvent event) {
        TFCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(ID, name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation lsPrefix(String name) {
        return new ResourceLocation(ID, "lostsouls/" + name.toLowerCase(Locale.ROOT) + "/" + name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation lsPrefixNoRepeat(String name) {
        return new ResourceLocation(ID, "lostsouls/" + name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation namedRegistry(String name) {
        return new ResourceLocation(REGISTRY_NAMESPACE, name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation getModelTexture(String name) {
        return new ResourceLocation(ID, MODEL_DIR + name);
    }

    public static ResourceLocation getGuiTexture(String name) {
        return new ResourceLocation(ID, GUI_DIR + name);
    }

    public static ResourceLocation getEnvTexture(String name) {
        return new ResourceLocation(ID, ENVIRO_DIR + name);
    }

    public static Rarity getRarity() {
        return rarity;
    }
}

