/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageModClient;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.block.InventoryCableBlock;
import com.tom.storagemod.tile.InventoryCableConnectorBlockEntity;
import com.tom.storagemod.util.TickerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InventoryCableConnectorBlock
extends BaseEntityBlock
implements IInventoryCable {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final Direction[] FACING_VALUES = Direction.values();
    protected VoxelShape[][] shapes = this.makeShapes(0.125f);

    public InventoryCableConnectorBlock() {
        this(false);
    }

    protected InventoryCableConnectorBlock(boolean dummy) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60978_(3.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.DOWN));
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        StorageModClient.tooltip("inventory_cable_connector", tooltip, new Object[0]);
        if (Config.get().invLinkBeaconLvl != -1) {
            StorageModClient.tooltip("inventory_cable_connector_link.beacon1", false, tooltip, Config.get().invLinkBeaconLvl);
            if (Config.get().invLinkBeaconLvlDim != -1) {
                StorageModClient.tooltip("inventory_cable_connector_link.beacon2", false, tooltip, Config.get().invLinkBeaconLvlDim);
            }
            StorageModClient.tooltip("inventory_cable_connector_link", false, tooltip, new Object[0]);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InventoryCableConnectorBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, FACING});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction f = (Direction)stateIn.m_61143_((Property)FACING);
        if (facing == f) {
            return (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(!facingState.m_60795_()));
        }
        return (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(IInventoryCable.canConnect(facingState, facing)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.withConnectionProperties((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_()), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean canConnectFrom(BlockState state, Direction dir) {
        return state.m_61143_((Property)FACING) != dir;
    }

    @Override
    public List<BlockPos> next(Level world, BlockState state, BlockPos pos) {
        Direction f = (Direction)state.m_61143_((Property)FACING);
        ArrayList<BlockPos> next = new ArrayList<BlockPos>();
        for (Direction d : Direction.values()) {
            if (d == f || !((Boolean)state.m_61143_((Property)InventoryCableBlock.DIR_TO_PROPERTY[d.ordinal()])).booleanValue()) continue;
            next.add(pos.m_121945_(d));
        }
        return next;
    }

    public BlockState withConnectionProperties(BlockState state, LevelAccessor blockView_1, BlockPos blockPos_1) {
        BlockState block_1 = blockView_1.m_8055_(blockPos_1.m_7495_());
        BlockState block_2 = blockView_1.m_8055_(blockPos_1.m_7494_());
        BlockState block_3 = blockView_1.m_8055_(blockPos_1.m_122012_());
        BlockState block_4 = blockView_1.m_8055_(blockPos_1.m_122029_());
        BlockState block_5 = blockView_1.m_8055_(blockPos_1.m_122019_());
        BlockState block_6 = blockView_1.m_8055_(blockPos_1.m_122024_());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnect(state, block_1, Direction.DOWN)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.canConnect(state, block_2, Direction.UP)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(state, block_3, Direction.NORTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(state, block_4, Direction.EAST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(state, block_5, Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(state, block_6, Direction.WEST)));
    }

    private boolean canConnect(BlockState state, BlockState block, Direction dir) {
        Direction f = (Direction)state.m_61143_((Property)FACING);
        return dir != f && IInventoryCable.canConnect(block, dir) || dir == f && !block.m_60795_();
    }

    public BlockState m_6843_(BlockState blockState_1, Rotation blockRotation_1) {
        switch (blockRotation_1) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState_1.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState_1.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState_1.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState_1.m_61143_((Property)EAST)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState_1.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState_1.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState_1.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState_1.m_61143_((Property)NORTH)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState_1.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)blockState_1.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState_1.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState_1.m_61143_((Property)SOUTH)));
            }
        }
        return blockState_1;
    }

    public BlockState m_6943_(BlockState blockState_1, Mirror blockMirror_1) {
        switch (blockMirror_1) {
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState_1.m_61124_((Property)NORTH, (Comparable)((Boolean)blockState_1.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)blockState_1.m_61143_((Property)NORTH)));
            }
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState_1.m_61124_((Property)EAST, (Comparable)((Boolean)blockState_1.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)blockState_1.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(blockState_1, blockMirror_1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[((Direction)state.m_61143_((Property)FACING)).ordinal()][this.getShapeIndex(state)];
    }

    protected int getShapeIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(FACING_VALUES[j]))).booleanValue()) continue;
            i |= 1 << j;
        }
        return i;
    }

    private VoxelShape[][] makeShapes(float apothem) {
        float f = 0.5f - apothem;
        float f1 = 0.5f + apothem;
        VoxelShape voxelshape = Block.m_49796_((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        VoxelShape[] avoxelshape = new VoxelShape[FACING_VALUES.length];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            avoxelshape[i] = Shapes.m_83048_((double)(0.5 + Math.min((double)(-apothem), (double)direction.m_122429_() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.m_122430_() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.m_122431_() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.m_122429_() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.m_122430_() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.m_122431_() * 0.5)));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < FACING_VALUES.length; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        VoxelShape[][] ret = new VoxelShape[6][64];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            VoxelShape s = Shapes.m_83124_((VoxelShape)InventoryCableConnectorBlock.createShape(direction, 16.0f, 0.0f, 16.0f, 0.0f, 2.0f, 0.0f), (VoxelShape[])new VoxelShape[]{InventoryCableConnectorBlock.createShape(direction, 10.0f, 3.0f, 10.0f, 3.0f, 2.0f, 2.0f), InventoryCableConnectorBlock.createShape(direction, 6.0f, 5.0f, 6.0f, 5.0f, 2.0f, 4.0f)});
            for (int j = 0; j < avoxelshape1.length; ++j) {
                ret[i][j] = Shapes.m_83110_((VoxelShape)avoxelshape1[j], (VoxelShape)s);
            }
        }
        return ret;
    }

    private static VoxelShape createShape(Direction dir, float width, float widthoff, float height, float heightoff, float depth, float depthoff) {
        switch (dir) {
            case DOWN: {
                return InventoryCableConnectorBlock.box(heightoff, depthoff, widthoff, height + heightoff, depth + depthoff, width + widthoff);
            }
            case EAST: {
                return InventoryCableConnectorBlock.box(16.0f - depth, heightoff, widthoff, 16.0f - depthoff, height + heightoff, width + widthoff);
            }
            case NORTH: {
                return InventoryCableConnectorBlock.box(widthoff, heightoff, depthoff, width + widthoff, height + heightoff, depth + depthoff);
            }
            case SOUTH: {
                return InventoryCableConnectorBlock.box(widthoff, heightoff, 16.0f - depth, width + widthoff, height + heightoff, 16.0f - depthoff);
            }
            case UP: {
                return InventoryCableConnectorBlock.box(heightoff, 16.0f - depth, widthoff, height + heightoff, 16.0f - depthoff, width + widthoff);
            }
            case WEST: {
                return InventoryCableConnectorBlock.box(depthoff, heightoff, widthoff, depth + depthoff, height + heightoff, width + widthoff);
            }
        }
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public static VoxelShape box(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        return Block.m_49796_((double)Math.min(xMin, xMax), (double)Math.min(yMin, yMax), (double)Math.min(zMin, zMax), (double)Math.max(xMin, xMax), (double)Math.max(yMin, yMax), (double)Math.max(zMin, zMax));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction f = (Direction)state.m_61143_((Property)FACING);
        BlockState pointedAt = world.m_8055_(pos.m_121945_(f));
        if (player.m_21120_(handIn).m_41619_() && pointedAt.m_60713_(Blocks.f_50273_)) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity_1 = world.m_7702_(pos);
            if (blockEntity_1 instanceof InventoryCableConnectorBlockEntity) {
                InventoryCableConnectorBlockEntity te = (InventoryCableConnectorBlockEntity)blockEntity_1;
                if (te.stillValid(player)) {
                    player.m_5893_((MenuProvider)te);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"chat.toms_storage.inv_link_access_denied"), true);
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

