/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.util.properties;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;

public class TemporalItemProperties {
    private static volatile TemporalItemProperties instance;

    private TemporalItemProperties() {
    }

    public void putCompostable(ItemLike itemLike, float value) {
        ComposterBlock.f_51914_.put((Object)itemLike, value);
    }

    public void makeBow(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientLevel, livingEntity, number) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientLevel, livingEntity, number) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    public void makeCrossbow(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (itemStack, level, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return CrossbowItem.m_40932_((ItemStack)itemStack) ? 0.0f : (float)(itemStack.m_41779_() - entity.m_21212_()) / (float)CrossbowItem.m_40939_((ItemStack)itemStack);
        });
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, level, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == itemStack && !CrossbowItem.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("charged"), (itemStack, level, entity, seed) -> entity != null && CrossbowItem.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("firework"), (itemStack, level, entity, seed) -> entity != null && CrossbowItem.m_40932_((ItemStack)itemStack) && CrossbowItem.m_40871_((ItemStack)itemStack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
    }

    public static void makeShield(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("blocking"), (itemStack, clientLevel, livingEntity, number) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TemporalItemProperties getInstance() {
        if (instance != null) return instance;
        Class<TemporalItemProperties> clazz = TemporalItemProperties.class;
        synchronized (TemporalItemProperties.class) {
            if (instance != null) return instance;
            instance = new TemporalItemProperties();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

