/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.registry.factory.common;

import com.google.common.collect.ImmutableSet;
import com.temporal.api.core.engine.io.EnginedRegisterFactory;
import com.temporal.api.core.registry.factory.common.TypedFactory;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class PoiTypeFactory
implements TypedFactory<PoiType> {
    public static final DeferredRegister<PoiType> POI_TYPES = EnginedRegisterFactory.create(Registries.f_256805_);
    private static volatile PoiTypeFactory instance;

    public RegistryObject<PoiType> create(String name, Block block, int maxTickets, int validRange) {
        return this.create(name, (Set<BlockState>)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), maxTickets, validRange);
    }

    public RegistryObject<PoiType> create(String name, Set<BlockState> matchingStates, int maxTickets, int validRange) {
        return this.create(name, () -> new PoiType(matchingStates, maxTickets, validRange));
    }

    @Override
    public RegistryObject<PoiType> create(String name, Supplier<PoiType> poiSupplier) {
        return POI_TYPES.register(name, poiSupplier);
    }

    @Override
    public RegistryObject<? extends PoiType> createTyped(String name, Supplier<? extends PoiType> tSupplier) {
        return POI_TYPES.register(name, tSupplier);
    }

    @Override
    public void register(IEventBus eventBus) {
        POI_TYPES.register(eventBus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PoiTypeFactory getInstance() {
        if (instance != null) return instance;
        Class<PoiTypeFactory> clazz = PoiTypeFactory.class;
        synchronized (PoiTypeFactory.class) {
            if (instance != null) return instance;
            instance = new PoiTypeFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

