/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine.metadata;

import com.temporal.api.ApiMod;
import com.temporal.api.core.engine.metadata.strategy.ClassAnnotationStrategy;
import com.temporal.api.core.engine.metadata.strategy.FieldAnnotationStrategy;
import com.temporal.api.core.engine.metadata.strategy.StrategyType;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;

public class AnnotationHelper {
    private static volatile AnnotationHelper instance;

    private AnnotationHelper() {
    }

    public void executeStrategy(ClassAnnotationStrategy strategy, Class<?> clazz, Class<? extends Annotation> annotation) throws NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        boolean isAnnotationPresented = this.checkAnnotationPresented(clazz, annotation);
        if (isAnnotationPresented) {
            strategy.execute(clazz);
            ApiMod.LOGGER.debug("Scanned: strategy - {}, class - {}, type - {}", new Object[]{strategy.getClass().getSimpleName(), clazz.getSimpleName(), StrategyType.CLASS_ANNOTATION});
        }
    }

    public void executeStrategy(FieldAnnotationStrategy strategy, Class<?> clazz, Class<? extends Annotation> annotation, Object object) throws NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        boolean isAnnotationPresented = this.checkAnnotationPresented(clazz, annotation);
        if (isAnnotationPresented) {
            strategy.execute(clazz, object);
            ApiMod.LOGGER.debug("Scanned: strategy - {}, class - {}, type - {}", new Object[]{strategy.getClass().getSimpleName(), clazz.getSimpleName(), StrategyType.FIELD_ANNOTATION});
        }
    }

    public boolean checkAnnotationPresented(Class<?> clazz, Class<? extends Annotation> annotation) {
        return clazz != null && clazz.isAnnotationPresent(annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnnotationHelper getInstance() {
        if (instance != null) return instance;
        Class<AnnotationHelper> clazz = AnnotationHelper.class;
        synchronized (AnnotationHelper.class) {
            if (instance != null) return instance;
            instance = new AnnotationHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

