/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine.metadata;

import com.temporal.api.ApiMod;
import com.temporal.api.core.engine.IOLayer;
import com.temporal.api.core.engine.metadata.AnnotationHelper;
import com.temporal.api.core.engine.metadata.strategy.AnnotationScanStrategy;
import com.temporal.api.core.engine.metadata.strategy.ClassAnnotationStrategy;
import com.temporal.api.core.engine.metadata.strategy.SimpleAnnotationScanStrategy;
import java.util.Set;

public class AnnotationExecutor {
    private static volatile AnnotationExecutor instance;
    private AnnotationScanStrategy annotationScanStrategy = new SimpleAnnotationScanStrategy();
    private ClassAnnotationStrategy loggingRegistryAnnotationStrategy;

    private AnnotationExecutor() {
    }

    public void execute() {
        try {
            AnnotationHelper helper = AnnotationHelper.getInstance();
            ApiMod.LOGGER.info("Annotation Strategy has been started: strategy - {}, class - {}", (Object)this.annotationScanStrategy.getClass().getSimpleName(), (Object)IOLayer.DEPENDENCY_INFO.getModClass().getSimpleName());
            Set<Class<?>> set = this.annotationScanStrategy.scan();
        }
        catch (Exception e) {
            ApiMod.LOGGER.error(e.getMessage());
        }
    }

    public AnnotationScanStrategy getAnnotationScanStrategy() {
        return this.annotationScanStrategy;
    }

    public void setAnnotationScanStrategy(AnnotationScanStrategy annotationScanStrategy) {
        this.annotationScanStrategy = annotationScanStrategy;
    }

    public ClassAnnotationStrategy getLoggingRegistryAnnotationStrategy() {
        return this.loggingRegistryAnnotationStrategy;
    }

    public void setLoggingRegistryAnnotationStrategy(ClassAnnotationStrategy loggingRegistryAnnotationStrategy) {
        this.loggingRegistryAnnotationStrategy = loggingRegistryAnnotationStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnnotationExecutor getInstance() {
        if (instance != null) return instance;
        Class<AnnotationExecutor> clazz = AnnotationExecutor.class;
        synchronized (AnnotationExecutor.class) {
            if (instance != null) return instance;
            instance = new AnnotationExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

