/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.criteria.TTCCriteriaTriggers;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MoveFactory;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerDoChessBoardInteraction {
    private final BlockPos pos;
    private final byte tileCoordinate;

    public MessageServerDoChessBoardInteraction(BlockPos pos, byte tileCoordinate) {
        this.pos = pos;
        this.tileCoordinate = tileCoordinate;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.tileCoordinate);
    }

    public static MessageServerDoChessBoardInteraction deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        byte tileCoordinate = buf.readByte();
        return new MessageServerDoChessBoardInteraction(pos, tileCoordinate);
    }

    public static void handle(MessageServerDoChessBoardInteraction message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos pos = message.pos;
        byte tileCoordinate = message.tileCoordinate;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                Level level;
                BlockEntity blockEntity;
                if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(pos)) instanceof ChessBlockEntity) {
                    ChessBlockEntity chessBlockEntity = (ChessBlockEntity)blockEntity;
                    if (chessBlockEntity.getBoard() == null) {
                        return;
                    }
                    if (chessBlockEntity.doingAnimationTimer > 0L && chessBlockEntity.move != null && chessBlockEntity.transition != null) {
                        chessBlockEntity.setBoard(chessBlockEntity.transition.getTransitionBoard());
                        chessBlockEntity.getMoveLog().addMove(chessBlockEntity.move);
                        if (chessBlockEntity.move.isPawnPromotion()) {
                            chessBlockEntity.setWaitingForPromotion(true);
                            chessBlockEntity.setPromotionCoordinate((byte)chessBlockEntity.move.getDestinationCoordinate());
                            List players = player.m_284548_().m_6907_();
                            for (ServerPlayer serverPlayer : players) {
                                if (!serverPlayer.m_20148_().equals(chessBlockEntity.getPromotionPlayerUUID())) continue;
                                NetworkUtil.openChessPromotionFromServer(chessBlockEntity.m_58899_(), chessBlockEntity.move.getMovedPiece().getPieceColor().isWhite(), serverPlayer);
                            }
                            chessBlockEntity.setPromotionPlayerUUID(null);
                        }
                        if (chessBlockEntity.getDisplayParticles() && !chessBlockEntity.playedParticles && chessBlockEntity.move.isAttack() && !chessBlockEntity.move.isEnPassantMove()) {
                            NetworkUtil.playChesParticlesFromServer(level, pos, (byte)chessBlockEntity.move.getDestinationCoordinate(), chessBlockEntity.move.getMovedPiece().getPieceColor().isBlack(), 0.0f, 0.0f, 0.0f);
                        }
                        chessBlockEntity.doingAnimationTimer = 0L;
                        chessBlockEntity.move = null;
                        chessBlockEntity.transition = null;
                        chessBlockEntity.playedParticles = false;
                        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                        chessBlockEntity.m_6596_();
                    }
                    BaseChessTile chessTile = chessBlockEntity.getBoard().getTile(tileCoordinate);
                    if (chessBlockEntity.getSourceTile() == null) {
                        if (chessTile.isTileOccupied() && chessTile.getPiece().getPieceColor() == chessBlockEntity.getBoard().getCurrentChessPlayer().getPieceColor()) {
                            chessBlockEntity.setSourceTile(chessTile);
                            chessBlockEntity.setHumanMovedPiece(chessTile.getPiece());
                            if (chessBlockEntity.getHumanMovedPiece() == null) {
                                chessBlockEntity.setSourceTile(null);
                            }
                            level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                            chessBlockEntity.m_6596_();
                        }
                    } else {
                        chessBlockEntity.setDestinationTile(chessTile);
                        BaseMove move = MoveFactory.createMove(chessBlockEntity.getBoard(), chessBlockEntity.getSourceTile().getTileCoordinate(), chessBlockEntity.getDestinationTile().getTileCoordinate());
                        MoveTransition transition = chessBlockEntity.getBoard().getCurrentChessPlayer().makeMove(move);
                        if (transition.getMoveStatus().isDone()) {
                            if (move.isPawnPromotion()) {
                                chessBlockEntity.setPromotionPlayerUUID(player.m_20148_());
                            }
                            if (chessBlockEntity.getPlayPieceAnimations()) {
                                chessBlockEntity.move = move;
                                chessBlockEntity.transition = transition;
                                int animTime = 1000;
                                if (move.getMovedPiece().getPieceType().isKing() && !move.isCastlingMove()) {
                                    animTime = 750;
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.PAWN) && Math.abs(move.getDestinationCoordinate() - move.getCurrentCoordinate()) <= 9) {
                                    animTime = 750;
                                }
                                if (move.isEnPassantMove()) {
                                    animTime = 1000;
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.ROOK)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.BISHOP)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.QUEEN)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                chessBlockEntity.doingAnimationTimer = System.currentTimeMillis() + (long)animTime;
                                NetworkUtil.setChessAnimationForAllTracking(level, pos, (byte)2, (byte)move.getCurrentCoordinate(), (byte)move.getDestinationCoordinate());
                            } else {
                                chessBlockEntity.setBoard(transition.getTransitionBoard());
                                chessBlockEntity.getMoveLog().addMove(move);
                                if (move.isPawnPromotion()) {
                                    chessBlockEntity.setWaitingForPromotion(true);
                                    chessBlockEntity.setPromotionCoordinate((byte)move.getDestinationCoordinate());
                                    List players = player.m_284548_().m_6907_();
                                    for (ServerPlayer serverPlayer : players) {
                                        if (!serverPlayer.m_20148_().equals(chessBlockEntity.getPromotionPlayerUUID())) continue;
                                        NetworkUtil.openChessPromotionFromServer(chessBlockEntity.m_58899_(), move.getMovedPiece().getPieceColor().isWhite(), serverPlayer);
                                    }
                                    chessBlockEntity.setPromotionPlayerUUID(null);
                                }
                                if (chessBlockEntity.getDisplayParticles() && move.isAttack() && !move.isEnPassantMove()) {
                                    NetworkUtil.playChesParticlesFromServer(level, pos, (byte)move.getDestinationCoordinate(), move.getMovedPiece().getPieceColor().isBlack(), 0.0f, 0.0f, 0.0f);
                                }
                            }
                            if (!level.f_46443_) {
                                TTCCriteriaTriggers.MAKE_CHESS_MOVE.trigger(player);
                            }
                            if (move.isEnPassantMove() && !level.f_46443_) {
                                TTCCriteriaTriggers.MAKE_EN_PASSANT_MOVE.trigger(player);
                            }
                            if (chessBlockEntity.getBoard().getCurrentChessPlayer().isInCheckMate() && !level.f_46443_) {
                                TTCCriteriaTriggers.MAKE_CHECK_MATE_MOVE.trigger(player);
                            }
                        }
                        chessBlockEntity.setSourceTile(null);
                        chessBlockEntity.setDestinationTile(null);
                        chessBlockEntity.setHumanMovedPiece(null);
                        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                        chessBlockEntity.m_6596_();
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

