/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.board.moves;

import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;

abstract class CastleMove
extends BaseMove {
    protected final RookPiece castleRook;
    protected final int castleRookStart;
    protected final int castleRookDestination;

    public CastleMove(Board board, BasePiece movedPiece, int destinationCoordinate, RookPiece castleRook, int castleRookStart, int castleRookDestination) {
        super(board, movedPiece, destinationCoordinate);
        this.castleRook = castleRook;
        this.castleRookStart = castleRookStart;
        this.castleRookDestination = castleRookDestination;
    }

    public RookPiece getCastleRook() {
        return this.castleRook;
    }

    @Override
    public boolean isCastlingMove() {
        return true;
    }

    @Override
    public Board execute() {
        Board.Builder builder = new Board.Builder();
        for (BasePiece piece : this.board.getCurrentChessPlayer().getActivePieces()) {
            if (this.movedPiece.equals(piece) || this.castleRook.equals(piece)) continue;
            builder.setPiece(piece);
        }
        for (BasePiece piece : this.board.getCurrentChessPlayer().getOpponent().getActivePieces()) {
            builder.setPiece(piece);
        }
        builder.setPiece(this.movedPiece.movePiece(this));
        builder.setPiece(new RookPiece(this.castleRook.getPieceColor(), this.castleRookDestination));
        builder.setMoveMaker(this.board.getCurrentChessPlayer().getOpponent().getPieceColor());
        return builder.build();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.castleRook.hashCode();
        result = 31 * result + this.castleRookDestination;
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CastleMove)) {
            return false;
        }
        CastleMove otherCastleMove = (CastleMove)object;
        return super.equals(otherCastleMove) && this.castleRook.equals(otherCastleMove.getCastleRook());
    }

    @Override
    public String saveToNBT() {
        return "";
    }
}

