/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities.model.chess;

import andrews.table_top_craft.animation.model.AdvancedMeshDefinition;
import andrews.table_top_craft.animation.model.AdvancedModelPart;
import andrews.table_top_craft.animation.model.AdvancedPartDefinition;
import andrews.table_top_craft.animation.model.AnimatedBlockEntityModel;
import andrews.table_top_craft.animation.system.base.AnimatedBlockEntity;
import andrews.table_top_craft.animation.system.core.AdvancedAnimationState;
import andrews.table_top_craft.block_entities.ChessBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class GhostModel
extends AnimatedBlockEntityModel {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(new ResourceLocation("table_top_craft", "ghost_model"), "main");
    public final AdvancedModelPart root;
    public final AdvancedModelPart selected;
    public final AdvancedModelPart moved;
    public final AdvancedModelPart affected;

    public GhostModel(ModelPart root) {
        super(RenderType::m_110458_);
        this.root = (AdvancedModelPart)root.m_171324_("root");
        this.selected = this.root.getChild("selected");
        this.moved = this.root.getChild("moved");
        this.affected = this.root.getChild("affected");
    }

    public static LayerDefinition createBodyLayer() {
        AdvancedMeshDefinition meshDefinition = new AdvancedMeshDefinition();
        AdvancedPartDefinition partDefinition = meshDefinition.getAdvancedRoot();
        AdvancedPartDefinition root = partDefinition.addOrReplaceChild("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        AdvancedPartDefinition selected = root.addOrReplaceChild("selected", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        AdvancedPartDefinition moved = root.addOrReplaceChild("moved", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        AdvancedPartDefinition affected = root.addOrReplaceChild("affected", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition.overwriteRootChildren(partDefinition), (int)0, (int)0);
    }

    @Override
    public void updateAnimations(AnimatedBlockEntity blockEntity, float partialTick) {
        if (blockEntity instanceof ChessBlockEntity) {
            ChessBlockEntity animated = (ChessBlockEntity)blockEntity;
            this.root.m_171331_().forEach(ModelPart::m_233569_);
            animated.lingeringStates.removeIf(state -> !state.m_216984_());
            animated.lingeringStates.forEach(state -> this.animate((AdvancedAnimationState)((Object)state), (float)animated.getTicksExisted() + partialTick, 1.0f));
            this.animate(animated.selectedPieceState, (float)animated.getTicksExisted() + partialTick, 1.0f);
            this.animate(animated.placedState, (float)animated.getTicksExisted() + partialTick, 1.0f);
            if (animated.moveState != null) {
                this.animate(animated.moveState, (float)animated.getTicksExisted() + partialTick, 1.0f);
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public AdvancedModelPart root() {
        return this.root;
    }
}

