/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities;

import andrews.table_top_craft.animation.system.base.AnimatedBlockEntity;
import andrews.table_top_craft.animation.system.core.AdvancedAnimationState;
import andrews.table_top_craft.animation.system.core.Animation;
import andrews.table_top_craft.animation.system.core.types.EasingTypes;
import andrews.table_top_craft.block_entities.animations.ChessAnimations;
import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.ChessMoveLog;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.KingSideCastleMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnEnPassantAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnJumpMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnPromotion;
import andrews.table_top_craft.game_logic.chess.board.moves.QueenSideCastleMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pgn.FenUtil;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.BishopPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KingPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KnightPiece;
import andrews.table_top_craft.game_logic.chess.pieces.PawnPiece;
import andrews.table_top_craft.game_logic.chess.pieces.QueenPiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.registry.TTCBlockEntities;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ChessBlockEntity
extends AnimatedBlockEntity {
    public final List<AdvancedAnimationState> lingeringStates = new ArrayList<AdvancedAnimationState>();
    public final AdvancedAnimationState selectedPieceState = new AdvancedAnimationState(new AtomicReference<Animation>());
    public AdvancedAnimationState moveState;
    public int selectedPiecePos;
    public final AdvancedAnimationState placedState = new AdvancedAnimationState(new AtomicReference<Animation>());
    public long doingAnimationTimer;
    public BaseMove move;
    public MoveTransition transition;
    public byte currentCord;
    public byte destCord;
    public boolean playedParticles;
    private Board board;
    private BaseChessTile sourceTile;
    private BaseChessTile destinationTile;
    private BasePiece humanMovedPiece;
    private final ChessMoveLog moveLog;
    private boolean showTileInfo;
    private boolean showAvailableMoves;
    private boolean showPreviousMove;
    private boolean useCustomPlate;
    private boolean playPieceAnimations = true;
    private boolean displayParticles = true;
    private boolean waitingForPromotion;
    private byte promotionCoordinate = (byte)-1;
    private UUID promotionPlayerUUID;
    private boolean whiteCheckMate = false;
    private boolean blackCheckMate = false;
    private String tileInfoColor;
    private String whiteTilesColor;
    private String blackTilesColor;
    private String whitePiecesColor;
    private String blackPiecesColor;
    private String legalMoveColor;
    private String invalidMoveColor;
    private String attackMoveColor;
    private String previousMoveColor;
    private String castleMoveColor;
    private int pieceSet;
    private BasePiece cachedPiece;
    private final List<MoveTransition> moveTransitionsCache = new ArrayList<MoveTransition>();

    public ChessBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TTCBlockEntities.CHESS.get(), pos, state);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.selectedPieceState.setAnimation(ChessAnimations.SELECTED_PIECE);
            this.placedState.setAnimation(ChessAnimations.PLACED);
        });
        this.moveLog = new ChessMoveLog();
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox();
        return aabb.m_82363_(0.125, 0.4, 0.125).m_82363_(-0.125, 0.0, -0.125).m_165887_(aabb.m_82399_().f_82480_ - 0.0625);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.saveToNBT(compound);
        return compound;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveToNBT(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromNBT(compound);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ChessBlockEntity blockEntity) {
        blockEntity.incTicksExisted();
        if (blockEntity.placedState.m_216984_() && blockEntity.placedState.isFinished()) {
            blockEntity.placedState.m_216973_();
        }
        if (blockEntity.doingAnimationTimer != 0L) {
            if (blockEntity.doingAnimationTimer >= System.currentTimeMillis() && blockEntity.move != null && blockEntity.transition != null && blockEntity.move.isAttack() && !blockEntity.playedParticles) {
                int timeMod = 250;
                boolean isBlack = blockEntity.move.getMovedPiece().getPieceColor().isBlack();
                byte destCoordinate = (byte)blockEntity.move.getDestinationCoordinate();
                float xSpeed = 0.0f;
                float ySpeed = 0.0f;
                float zSpeed = 0.0f;
                if (blockEntity.move.isEnPassantMove()) {
                    destCoordinate = (byte)(destCoordinate + (isBlack ? -8 : 8));
                    timeMod = 400;
                    if (blockEntity.m_58900_().m_61138_((Property)ChessBlock.FACING)) {
                        switch ((Direction)blockEntity.m_58900_().m_61143_((Property)ChessBlock.FACING)) {
                            case NORTH: {
                                zSpeed = isBlack ? -0.4f : 0.4f;
                                break;
                            }
                            case SOUTH: {
                                zSpeed = isBlack ? 0.4f : -0.4f;
                                break;
                            }
                            case EAST: {
                                xSpeed = isBlack ? 0.4f : -0.4f;
                                break;
                            }
                            case WEST: {
                                xSpeed = isBlack ? -0.4f : 0.4f;
                            }
                        }
                    }
                } else if (blockEntity.move.isAttack()) {
                    BasePiece.PieceType type = blockEntity.move.getMovedPiece().getPieceType();
                    int startX = blockEntity.move.getCurrentCoordinate() % 8;
                    int startY = blockEntity.move.getCurrentCoordinate() / 8;
                    int destX = blockEntity.move.getDestinationCoordinate() % 8;
                    int destY = blockEntity.move.getDestinationCoordinate() / 8;
                    int deltaY = startY - destY;
                    deltaY = !isBlack ? deltaY : -deltaY;
                    int deltaX = startX - destX;
                    deltaX = !isBlack ? -deltaX : deltaX;
                    float[] result = ChessBlockEntity.calculateSpeedAndTimeMod(type, isBlack, (Direction)blockEntity.m_58900_().m_61143_((Property)ChessBlock.FACING), deltaY, deltaX);
                    zSpeed = result[0];
                    xSpeed = result[1];
                    timeMod = (int)result[2];
                }
                if (blockEntity.doingAnimationTimer - (long)timeMod < System.currentTimeMillis()) {
                    if (blockEntity.getDisplayParticles() && !level.m_5776_()) {
                        NetworkUtil.playChesParticlesFromServer(level, pos, destCoordinate, isBlack, xSpeed, ySpeed, zSpeed);
                    }
                    blockEntity.playedParticles = true;
                }
            }
            if (blockEntity.doingAnimationTimer < System.currentTimeMillis() && blockEntity.move != null && blockEntity.transition != null) {
                blockEntity.setBoard(blockEntity.transition.getTransitionBoard());
                blockEntity.getMoveLog().addMove(blockEntity.move);
                if (blockEntity.move.isPawnPromotion()) {
                    blockEntity.setWaitingForPromotion(true);
                    blockEntity.setPromotionCoordinate((byte)blockEntity.move.getDestinationCoordinate());
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        List players = serverLevel.m_6907_();
                        for (ServerPlayer serverPlayer : players) {
                            if (!serverPlayer.m_20148_().equals(blockEntity.getPromotionPlayerUUID())) continue;
                            NetworkUtil.openChessPromotionFromServer(blockEntity.m_58899_(), blockEntity.move.getMovedPiece().getPieceColor().isWhite(), serverPlayer);
                        }
                    }
                    blockEntity.setPromotionPlayerUUID(null);
                }
                blockEntity.doingAnimationTimer = 0L;
                blockEntity.move = null;
                blockEntity.transition = null;
                blockEntity.playedParticles = false;
                level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                blockEntity.m_6596_();
            }
        }
        if (blockEntity.getHumanMovedPiece() != null) {
            if (blockEntity.getPlayPieceAnimations() && !blockEntity.selectedPieceState.m_216984_()) {
                blockEntity.selectedPiecePos = blockEntity.getHumanMovedPiece().getPiecePosition();
                blockEntity.lingeringStates.clear();
                blockEntity.selectedPieceState.interpolateAndStart(0.15f, EasingTypes.LINEAR, false, blockEntity.getTicksExisted());
            } else if (!blockEntity.getPlayPieceAnimations() && blockEntity.selectedPieceState.m_216984_()) {
                blockEntity.selectedPieceState.interpolateAndStop(0.15f, EasingTypes.LINEAR, false);
                blockEntity.lingeringStates.add(new AdvancedAnimationState(blockEntity.selectedPieceState));
                blockEntity.selectedPieceState.m_216973_();
            }
        } else if (blockEntity.selectedPieceState.m_216984_()) {
            blockEntity.selectedPieceState.interpolateAndStop(0.15f, EasingTypes.LINEAR, false);
            blockEntity.lingeringStates.add(new AdvancedAnimationState(blockEntity.selectedPieceState));
            blockEntity.selectedPieceState.m_216973_();
        }
    }

    private void saveToNBT(CompoundTag compound) {
        int i;
        CompoundTag chessNBT = new CompoundTag();
        if (this.board != null) {
            chessNBT.m_128359_("BoardFEN", FenUtil.createFENFromGame(this.board));
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < 64; ++i) {
                if (!this.board.getTile(i).isTileOccupied() || !this.board.getTile(i).getPiece().isFirstMove()) continue;
                builder.append(i).append("/");
            }
            if (builder.length() >= 2) {
                builder.setLength(builder.length() - 1);
            }
            chessNBT.m_128359_("FirstMoves", builder.toString());
            chessNBT.m_128379_("IsWhiteCastled", this.board.getWhiteChessPlayer().isCastled());
            chessNBT.m_128379_("IsBlackCastled", this.board.getBlackChessPlayer().isCastled());
            chessNBT.m_128379_("WhiteCheckMate", this.getBoard().getWhiteChessPlayer().isInCheckMate());
            chessNBT.m_128379_("BlackCheckMate", this.getBoard().getBlackChessPlayer().isInCheckMate());
        }
        if (this.moveLog != null) {
            ListTag chessMoves = new ListTag();
            for (i = 0; i < this.moveLog.size(); ++i) {
                CompoundTag chessMove = new CompoundTag();
                chessMove.m_128359_("Move" + (i + 1), this.moveLog.getMoves().get(i).saveToNBT());
                chessMoves.add((Object)chessMove);
            }
            chessNBT.m_128365_("MoveLog", (Tag)chessMoves);
        }
        chessNBT.m_128405_("ShowTileInfo", !this.showTileInfo ? 0 : 1);
        chessNBT.m_128405_("ShowAvailableMoves", !this.showAvailableMoves ? 0 : 1);
        chessNBT.m_128405_("ShowPreviousMove", !this.showPreviousMove ? 0 : 1);
        chessNBT.m_128405_("UseCustomPlate", !this.useCustomPlate ? 0 : 1);
        chessNBT.m_128405_("PlayPieceAnimations", !this.playPieceAnimations ? 0 : 1);
        chessNBT.m_128405_("DisplayParticles", !this.displayParticles ? 0 : 1);
        chessNBT.m_128405_("WaitingForPromotion", !this.waitingForPromotion ? 0 : 1);
        chessNBT.m_128344_("PromotionCoordinate", this.getPromotionCoordinate());
        chessNBT.m_128359_("TileInfoColor", this.getTileInfoColor());
        chessNBT.m_128359_("WhiteTilesColor", this.getWhiteTilesColor());
        chessNBT.m_128359_("BlackTilesColor", this.getBlackTilesColor());
        chessNBT.m_128359_("WhitePiecesColor", this.getWhitePiecesColor());
        chessNBT.m_128359_("BlackPiecesColor", this.getBlackPiecesColor());
        chessNBT.m_128359_("LegalMoveColor", this.getLegalMoveColor());
        chessNBT.m_128359_("InvalidMoveColor", this.getInvalidMoveColor());
        chessNBT.m_128359_("AttackMoveColor", this.getAttackMoveColor());
        chessNBT.m_128359_("PreviousMoveColor", this.getPreviousMoveColor());
        chessNBT.m_128359_("CastleMoveColor", this.getCastleMoveColor());
        chessNBT.m_128405_("SourceTile", this.sourceTile == null ? -1 : this.sourceTile.getTileCoordinate());
        chessNBT.m_128405_("HumanMovedPiece", this.humanMovedPiece == null ? -1 : this.humanMovedPiece.getPiecePosition());
        chessNBT.m_128405_("PieceSet", this.getPieceSet());
        compound.m_128365_("ChessValues", (Tag)chessNBT);
    }

    private void loadFromNBT(CompoundTag compound) {
        CompoundTag chessNBT = compound.m_128469_("ChessValues");
        if (chessNBT.m_128425_("BoardFEN", 8) && chessNBT.m_128425_("FirstMoves", 8)) {
            boolean isWhiteCastled = chessNBT.m_128471_("IsWhiteCastled");
            boolean isBlackCastled = chessNBT.m_128471_("IsBlackCastled");
            if (FenUtil.isFENValid(chessNBT.m_128461_("BoardFEN"))) {
                if (this.f_58857_ != null && this.f_58857_.m_5776_() && this.moveState != null && !FenUtil.createFENFromGame(this.board).equals(chessNBT.m_128461_("BoardFEN"))) {
                    this.moveState = null;
                }
                this.board = FenUtil.createGameFromFEN(chessNBT.m_128461_("BoardFEN"), chessNBT.m_128461_("FirstMoves"), isWhiteCastled, isBlackCastled);
            } else {
                this.board = Board.createStandardBoard();
            }
        }
        if (chessNBT.m_128441_("MoveLog")) {
            ListTag listNBT = chessNBT.m_128437_("MoveLog", 10);
            this.moveLog.clear();
            block24: for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag compoundTag = listNBT.m_128728_(i);
                String move = compoundTag.m_128461_("Move" + (i + 1));
                String[] moveInfo = move.split("/");
                PieceColor pieceColor = PieceColor.WHITE;
                if (moveInfo[1].equals("B")) {
                    pieceColor = PieceColor.BLACK;
                }
                switch (moveInfo[0]) {
                    default: {
                        continue block24;
                    }
                    case "pawn_jump": {
                        this.moveLog.addMove(new PawnJumpMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3])));
                        continue block24;
                    }
                    case "pawn_move": {
                        this.moveLog.addMove(new PawnMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3])));
                        continue block24;
                    }
                    case "pawn_attack": {
                        this.moveLog.addMove(new PawnAttackMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3]), this.getPieceFromType(moveInfo[5], pieceColor, Integer.parseInt(moveInfo[4]))));
                        continue block24;
                    }
                    case "pawn_enpassant": {
                        this.moveLog.addMove(new PawnEnPassantAttackMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3]), new PawnPiece(this.getOppositeColor(pieceColor), Integer.parseInt(moveInfo[4]))));
                        continue block24;
                    }
                    case "pawn_attack_promotion": {
                        this.moveLog.addMove(new PawnPromotion(new PawnAttackMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3]), this.getPieceFromType(moveInfo[5], pieceColor, Integer.parseInt(moveInfo[4]))), moveInfo[6]));
                        continue block24;
                    }
                    case "pawn_promotion": {
                        this.moveLog.addMove(new PawnPromotion(new PawnMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3])), moveInfo[4]));
                        continue block24;
                    }
                    case "major_move": {
                        this.moveLog.addMove(new MajorMove(this.getBoard(), this.getPieceFromType(moveInfo[4], this.getOppositeColor(pieceColor), Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3])));
                        continue block24;
                    }
                    case "major_attack": {
                        this.moveLog.addMove(new MajorAttackMove(this.getBoard(), this.getPieceFromType(moveInfo[3], this.getOppositeColor(pieceColor), Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[4]), this.getPieceFromType(moveInfo[6], pieceColor, Integer.parseInt(moveInfo[5]))));
                        continue block24;
                    }
                    case "king_side_castle": {
                        this.moveLog.addMove(new KingSideCastleMove(this.getBoard(), new KingPiece(pieceColor, Integer.parseInt(moveInfo[2]), false, false), Integer.parseInt(moveInfo[3]), new RookPiece(pieceColor, Integer.parseInt(moveInfo[4])), Integer.parseInt(moveInfo[5]), Integer.parseInt(moveInfo[6])));
                        continue block24;
                    }
                    case "queen_side_castle": {
                        this.moveLog.addMove(new QueenSideCastleMove(this.getBoard(), new KingPiece(pieceColor, Integer.parseInt(moveInfo[2]), false, false), Integer.parseInt(moveInfo[3]), new RookPiece(pieceColor, Integer.parseInt(moveInfo[4])), Integer.parseInt(moveInfo[5]), Integer.parseInt(moveInfo[6])));
                    }
                }
            }
        }
        if (chessNBT.m_128425_("ShowTileInfo", 3)) {
            boolean bl = this.showTileInfo = chessNBT.m_128451_("ShowTileInfo") != 0;
        }
        if (chessNBT.m_128425_("ShowAvailableMoves", 3)) {
            boolean bl = this.showAvailableMoves = chessNBT.m_128451_("ShowAvailableMoves") != 0;
        }
        if (chessNBT.m_128425_("ShowPreviousMove", 3)) {
            boolean bl = this.showPreviousMove = chessNBT.m_128451_("ShowPreviousMove") != 0;
        }
        if (chessNBT.m_128425_("TileInfoColor", 8)) {
            this.tileInfoColor = chessNBT.m_128461_("TileInfoColor");
        }
        if (chessNBT.m_128425_("UseCustomPlate", 3)) {
            boolean bl = this.useCustomPlate = chessNBT.m_128451_("UseCustomPlate") != 0;
        }
        if (chessNBT.m_128425_("PlayPieceAnimations", 3)) {
            boolean bl = this.playPieceAnimations = chessNBT.m_128451_("PlayPieceAnimations") != 0;
        }
        if (chessNBT.m_128425_("DisplayParticles", 3)) {
            boolean bl = this.displayParticles = chessNBT.m_128451_("DisplayParticles") != 0;
        }
        if (chessNBT.m_128425_("WaitingForPromotion", 3)) {
            boolean bl = this.waitingForPromotion = chessNBT.m_128451_("WaitingForPromotion") != 0;
        }
        if (chessNBT.m_128425_("PromotionCoordinate", 1)) {
            this.promotionCoordinate = chessNBT.m_128445_("PromotionCoordinate");
        }
        if (chessNBT.m_128425_("WhiteTilesColor", 8)) {
            this.whiteTilesColor = chessNBT.m_128461_("WhiteTilesColor");
        }
        if (chessNBT.m_128425_("BlackTilesColor", 8)) {
            this.blackTilesColor = chessNBT.m_128461_("BlackTilesColor");
        }
        if (chessNBT.m_128425_("WhitePiecesColor", 8)) {
            this.whitePiecesColor = chessNBT.m_128461_("WhitePiecesColor");
        }
        if (chessNBT.m_128425_("BlackPiecesColor", 8)) {
            this.blackPiecesColor = chessNBT.m_128461_("BlackPiecesColor");
        }
        if (chessNBT.m_128425_("LegalMoveColor", 8)) {
            this.legalMoveColor = chessNBT.m_128461_("LegalMoveColor");
        }
        if (chessNBT.m_128425_("InvalidMoveColor", 8)) {
            this.invalidMoveColor = chessNBT.m_128461_("InvalidMoveColor");
        }
        if (chessNBT.m_128425_("AttackMoveColor", 8)) {
            this.attackMoveColor = chessNBT.m_128461_("AttackMoveColor");
        }
        if (chessNBT.m_128425_("PreviousMoveColor", 8)) {
            this.previousMoveColor = chessNBT.m_128461_("PreviousMoveColor");
        }
        if (chessNBT.m_128425_("CastleMoveColor", 8)) {
            this.castleMoveColor = chessNBT.m_128461_("CastleMoveColor");
        }
        if (chessNBT.m_128425_("SourceTile", 3)) {
            BaseChessTile baseChessTile = this.sourceTile = chessNBT.m_128451_("SourceTile") == -1 ? null : this.getBoard().getTile(chessNBT.m_128451_("SourceTile"));
        }
        if (chessNBT.m_128425_("HumanMovedPiece", 3)) {
            BasePiece basePiece = this.humanMovedPiece = chessNBT.m_128451_("HumanMovedPiece") == -1 ? null : this.getBoard().getTile(chessNBT.m_128451_("HumanMovedPiece")).getPiece();
        }
        if (chessNBT.m_128425_("PieceSet", 3)) {
            this.pieceSet = chessNBT.m_128451_("PieceSet");
        }
        if (chessNBT.m_128441_("WhiteCheckMate")) {
            this.whiteCheckMate = chessNBT.m_128471_("WhiteCheckMate");
        }
        if (chessNBT.m_128441_("BlackCheckMate")) {
            this.blackCheckMate = chessNBT.m_128471_("BlackCheckMate");
        }
    }

    private static float[] calculateSpeedAndTimeMod(BasePiece.PieceType type, boolean isBlack, Direction facing, int deltaY, int deltaX) {
        float[] result = new float[3];
        float zSpeed = 0.0f;
        float xSpeed = 0.0f;
        int timeMod = 250;
        if (type.equals((Object)BasePiece.PieceType.ROOK)) {
            if (Math.abs(deltaY) > 4) {
                switch (facing) {
                    case NORTH: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case SOUTH: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case EAST: {
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case WEST: {
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                    }
                }
                timeMod = 550;
            }
            if (Math.abs(deltaX) > 4) {
                switch (facing) {
                    case NORTH: {
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case SOUTH: {
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case EAST: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case WEST: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                    }
                }
                timeMod = 550;
            }
        } else if (type.equals((Object)BasePiece.PieceType.BISHOP)) {
            if (Math.abs(deltaY) > 3) {
                switch (facing) {
                    case NORTH: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case SOUTH: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case EAST: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case WEST: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                    }
                }
                timeMod = 550;
            }
        } else if (type.equals((Object)BasePiece.PieceType.QUEEN)) {
            if (Math.abs(deltaX) != Math.abs(deltaY)) {
                if (Math.abs(deltaY) > 3) {
                    switch (facing) {
                        case NORTH: {
                            zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                            break;
                        }
                        case SOUTH: {
                            zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                            break;
                        }
                        case EAST: {
                            xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                            break;
                        }
                        case WEST: {
                            xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        }
                    }
                    timeMod = 550;
                }
                if (Math.abs(deltaX) > 3) {
                    switch (facing) {
                        case NORTH: {
                            xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                            break;
                        }
                        case SOUTH: {
                            xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                            break;
                        }
                        case EAST: {
                            zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                            break;
                        }
                        case WEST: {
                            zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        }
                    }
                    timeMod = 550;
                }
            } else if (Math.abs(deltaY) > 3) {
                switch (facing) {
                    case NORTH: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case SOUTH: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case EAST: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case WEST: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                    }
                }
                timeMod = 550;
            }
        }
        result[0] = zSpeed;
        result[1] = xSpeed;
        result[2] = timeMod;
        return result;
    }

    private BasePiece getPieceFromType(String pieceType, PieceColor pieceColor, int piecePosition) {
        return switch (pieceType) {
            case "P" -> new PawnPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "R" -> new RookPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "N" -> new KnightPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "B" -> new BishopPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "Q" -> new QueenPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "K" -> new KingPiece(this.getOppositeColor(pieceColor), piecePosition, true, true);
            default -> null;
        };
    }

    private PieceColor getOppositeColor(PieceColor color) {
        return color.isWhite() ? PieceColor.BLACK : PieceColor.WHITE;
    }

    public ChessMoveLog getMoveLog() {
        return this.moveLog;
    }

    public void setCastleMoveColor(String colorForNBT) {
        this.castleMoveColor = colorForNBT;
    }

    public String getCastleMoveColor() {
        return this.castleMoveColor == null ? NBTColorSaving.createCastleMoveColor() : this.castleMoveColor;
    }

    public void setPreviousMoveColor(String colorForNBT) {
        this.previousMoveColor = colorForNBT;
    }

    public String getPreviousMoveColor() {
        return this.previousMoveColor == null ? NBTColorSaving.createPreviousMoveColor() : this.previousMoveColor;
    }

    public void setAttackMoveColor(String colorForNBT) {
        this.attackMoveColor = colorForNBT;
    }

    public String getAttackMoveColor() {
        return this.attackMoveColor == null ? NBTColorSaving.createAttackMoveColor() : this.attackMoveColor;
    }

    public void setInvalidMoveColor(String colorForNBT) {
        this.invalidMoveColor = colorForNBT;
    }

    public String getInvalidMoveColor() {
        return this.invalidMoveColor == null ? NBTColorSaving.createInvalidMoveColor() : this.invalidMoveColor;
    }

    public void setLegalMoveColor(String colorForNBT) {
        this.legalMoveColor = colorForNBT;
    }

    public String getLegalMoveColor() {
        return this.legalMoveColor == null ? NBTColorSaving.createLegalMoveColor() : this.legalMoveColor;
    }

    public void setWhitePiecesColor(String colorForNBT) {
        this.whitePiecesColor = colorForNBT;
    }

    public String getWhitePiecesColor() {
        return this.whitePiecesColor == null ? NBTColorSaving.createWhitePiecesColor() : this.whitePiecesColor;
    }

    public void setBlackPiecesColor(String colorForNBT) {
        this.blackPiecesColor = colorForNBT;
    }

    public String getBlackPiecesColor() {
        return this.blackPiecesColor == null ? NBTColorSaving.createBlackPiecesColor() : this.blackPiecesColor;
    }

    public void setWhiteTilesColor(String colorForNBT) {
        this.whiteTilesColor = colorForNBT;
    }

    public String getWhiteTilesColor() {
        return this.whiteTilesColor == null ? NBTColorSaving.createWhiteTilesColor() : this.whiteTilesColor;
    }

    public void setBlackTilesColor(String colorForNBT) {
        this.blackTilesColor = colorForNBT;
    }

    public String getBlackTilesColor() {
        return this.blackTilesColor == null ? NBTColorSaving.createBlackTilesColor() : this.blackTilesColor;
    }

    public void setTileInfoColor(String colorForNBT) {
        this.tileInfoColor = colorForNBT;
    }

    public String getTileInfoColor() {
        return this.tileInfoColor == null ? NBTColorSaving.createWhiteColor() : this.tileInfoColor;
    }

    public void setShowPreviousMove(boolean shouldShowPreviousMove) {
        this.showPreviousMove = shouldShowPreviousMove;
    }

    public boolean getShowPreviousMove() {
        return this.showPreviousMove;
    }

    public void setShowAvailableMoves(boolean shouldShowAvailableMoves) {
        this.showAvailableMoves = shouldShowAvailableMoves;
    }

    public boolean getShowAvailableMoves() {
        return this.showAvailableMoves;
    }

    public void setUseCustomPlate(boolean shouldUseCustomPlate) {
        this.useCustomPlate = shouldUseCustomPlate;
    }

    public boolean getUseCustomPlate() {
        return this.useCustomPlate;
    }

    public void setPlayPieceAnimations(boolean shouldPlayPieceAnimations) {
        this.playPieceAnimations = shouldPlayPieceAnimations;
    }

    public boolean getPlayPieceAnimations() {
        return this.playPieceAnimations;
    }

    public void setDisplayParticles(boolean shouldDisplayParticles) {
        this.displayParticles = shouldDisplayParticles;
    }

    public boolean getDisplayParticles() {
        return this.displayParticles;
    }

    public void setShowTileInfo(boolean shouldShowTileInfo) {
        this.showTileInfo = shouldShowTileInfo;
    }

    public boolean getShouldShowTileInfo() {
        return this.showTileInfo;
    }

    public void setWaitingForPromotion(boolean waitingForPromotion) {
        this.waitingForPromotion = waitingForPromotion;
    }

    public boolean getWaitingForPromotion() {
        return this.waitingForPromotion;
    }

    public void setPromotionCoordinate(byte promotionCoordinate) {
        this.promotionCoordinate = promotionCoordinate;
    }

    public byte getPromotionCoordinate() {
        return this.promotionCoordinate;
    }

    public void setBoard(Board board) {
        this.board = board;
        this.m_6596_();
    }

    public Board getBoard() {
        return this.board;
    }

    public void setSourceTile(BaseChessTile sourceTile) {
        this.sourceTile = sourceTile;
    }

    public BaseChessTile getSourceTile() {
        return this.sourceTile;
    }

    public void setHumanMovedPiece(BasePiece humanMovedPiece) {
        this.humanMovedPiece = humanMovedPiece;
    }

    public BasePiece getHumanMovedPiece() {
        return this.humanMovedPiece;
    }

    public void setDestinationTile(BaseChessTile destinationTile) {
        this.destinationTile = destinationTile;
    }

    public BaseChessTile getDestinationTile() {
        return this.destinationTile;
    }

    public int getPieceSet() {
        return this.pieceSet;
    }

    public void setPieceSet(int set) {
        this.pieceSet = set;
        this.m_6596_();
    }

    public BasePiece getCachedPiece() {
        return this.cachedPiece;
    }

    public void setCachedPiece(BasePiece cachedPiece) {
        this.cachedPiece = cachedPiece;
    }

    public List<MoveTransition> getMoveTransitionsCache() {
        return this.moveTransitionsCache;
    }

    public void clearMoveTransitionsCache() {
        this.moveTransitionsCache.clear();
    }

    public void addToMoveTransitionsCache(MoveTransition transition) {
        this.moveTransitionsCache.add(transition);
    }

    public void setPromotionPlayerUUID(UUID uuid) {
        this.promotionPlayerUUID = uuid;
    }

    public UUID getPromotionPlayerUUID() {
        return this.promotionPlayerUUID;
    }

    public boolean isWhiteCheckMate() {
        return this.whiteCheckMate;
    }

    public boolean isBlackCheckMate() {
        return this.blackCheckMate;
    }
}

