/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SignPostBlockTileRenderer
implements BlockEntityRenderer<SignPostBlockTile> {
    public static final Map<WoodType, BakedModel> MODELS = new IdentityHashMap<WoodType, BakedModel>();
    private static ModelBlockRenderer renderer;
    private final Camera camera;
    private final Font font;

    public SignPostBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.camera = Minecraft.m_91087_().f_91063_.m_109153_();
        this.font = context.m_173586_();
        ModelManager manager = Minecraft.m_91087_().m_91304_();
        MODELS.clear();
        for (Map.Entry<WoodType, ResourceLocation> e : ClientRegistry.SIGN_POST_MODELS.get().entrySet()) {
            MODELS.put(e.getKey(), ClientHelper.getModel((ModelManager)manager, (ResourceLocation)e.getValue()));
        }
        renderer = Minecraft.m_91087_().m_91289_().m_110937_();
    }

    public int m_142163_() {
        return 32;
    }

    public void render(SignPostBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderSignsText(tile, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private void renderSignsText(SignPostBlockTile tile, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockPos pos = tile.m_58899_();
        Vec3 cameraPos = this.camera.m_90583_();
        LOD lod = new LOD(cameraPos, pos);
        if (!lod.isNear()) {
            return;
        }
        SignPostBlockTile.Sign signUp = tile.getSignUp();
        SignPostBlockTile.Sign signDown = tile.getSignDown();
        boolean up = signUp.active();
        boolean down = signDown.active();
        if (up || down) {
            TextUtil.RenderProperties textProperties;
            float relAngle = LOD.getRelativeAngle((Vec3)cameraPos, (BlockPos)pos);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (up && LOD.isOutOfFocus((float)relAngle, (float)(signUp.yaw() + 90.0f), (float)2.0f)) {
                Vector3f v = new Vector3f(1.0f, 0.0f, 0.0f);
                v.rotateY(signUp.yaw() * ((float)Math.PI / 180));
                textProperties = tile.getTextHolder(0).computeRenderProperties(combinedLightIn, v, () -> ((LOD)lod).isVeryNear());
                this.renderSignText(tile, poseStack, bufferIn, signUp, textProperties, 0);
            }
            if (down && LOD.isOutOfFocus((float)relAngle, (float)(signDown.yaw() + 90.0f), (float)2.0f)) {
                Vector3f normalVector = new Vector3f(1.0f, 0.0f, 0.0f);
                normalVector.rotateY(signUp.yaw() * ((float)Math.PI / 180));
                textProperties = tile.getTextHolder(1).computeRenderProperties(combinedLightIn, normalVector, () -> ((LOD)lod).isVeryNear());
                poseStack.m_85837_(0.0, -0.5, 0.0);
                this.renderSignText(tile, poseStack, bufferIn, signDown, textProperties, 1);
            }
            poseStack.m_85849_();
        }
    }

    private void renderSignText(SignPostBlockTile tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, SignPostBlockTile.Sign sign, TextUtil.RenderProperties textProperties, int line) {
        matrixStackIn.m_85836_();
        boolean left = sign.left();
        int o = left ? 1 : -1;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(sign.yaw() - 90.0f));
        if (tile.isSlim()) {
            matrixStackIn.m_252880_(0.0f, 0.0f, -0.0625f);
        }
        matrixStackIn.m_85837_(-0.03125 * (double)o, 0.28125, 0.1925);
        matrixStackIn.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        TextUtil.renderLine((FormattedCharSequence)tile.getTextHolder(line).getRenderMessages(0, this.font), (Font)this.font, (float)-4.0f, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (TextUtil.RenderProperties)textProperties);
        matrixStackIn.m_85849_();
    }

    public static void renderSigns(PoseStack poseStack, VertexConsumer builder, int combinedLightIn, int combinedOverlayIn, SignPostBlockTile.Sign signUp, SignPostBlockTile.Sign signDown, boolean slim) {
        boolean up = signUp.active();
        boolean down = signDown.active();
        if (up || down) {
            poseStack.m_85836_();
            if (down) {
                SignPostBlockTileRenderer.renderSign(poseStack, builder, combinedLightIn, combinedOverlayIn, signDown, slim);
            }
            if (up) {
                poseStack.m_85837_(0.0, 0.5, 0.0);
                SignPostBlockTileRenderer.renderSign(poseStack, builder, combinedLightIn, combinedOverlayIn, signUp, slim);
            }
            poseStack.m_85849_();
        }
    }

    public static void renderSign(PoseStack posestack, VertexConsumer builder, int light, int overlay, SignPostBlockTile.Sign sign, boolean slim) {
        posestack.m_85836_();
        boolean left = sign.left();
        posestack.m_85837_(0.5, 0.5, 0.5);
        posestack.m_252781_(Axis.f_252436_.m_252977_(sign.yaw() - 90.0f));
        if (slim) {
            posestack.m_252880_(0.0f, 0.0f, -0.0625f);
        }
        if (!left) {
            posestack.m_252781_(RotHlpr.YN180);
            posestack.m_85837_(0.0, 0.0, -0.3125);
        }
        posestack.m_85837_(-0.5, -0.5, -0.25);
        renderer.m_111067_(posestack.m_85850_(), builder, null, MODELS.get(sign.woodType()), 1.0f, 1.0f, 1.0f, light, overlay);
        posestack.m_85849_();
    }
}

