/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.command;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.command.SEComponents;
import net.spell_engine.command.SpellComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerSpellComponent
implements AutoSyncedComponent,
SpellComponent {
    private static final Logger log = LoggerFactory.getLogger(PlayerSpellComponent.class);
    public SpellContainer.ContentType content = SpellContainer.ContentType.MAGIC;
    private final class_1657 obj;
    private final List<String> spells = new ArrayList<String>();
    public static final String NBT_KEY_SPELL_IDS = "spell_ids";

    public PlayerSpellComponent(class_1657 obj) {
        this.obj = obj;
    }

    @Override
    public void addSpell(String spellId) {
        if (!this.spells.contains(spellId)) {
            this.spells.add(spellId);
            this.spells.sort(String::compareTo);
            SEComponents.SPELLS.sync((Object)this.obj);
            log.info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435: {}. \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a: {}", (Object)spellId, this.spells);
        } else {
            log.info("\u0417\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435 \u0443\u0436\u0435 \u0438\u0437\u0443\u0447\u0435\u043d\u043e: {}", (Object)spellId);
        }
    }

    @Override
    public void addSpells(List<String> spellIds) {
        boolean added = false;
        for (String spellId : spellIds) {
            if (this.spells.contains(spellId)) continue;
            this.spells.add(spellId);
            added = true;
        }
        if (added) {
            this.spells.sort(String::compareTo);
            SEComponents.SPELLS.sync((Object)this.obj);
            log.info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f: {}. \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a: {}", spellIds, this.spells);
        } else {
            log.info("\u0412\u0441\u0435 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u0443\u0436\u0435 \u0438\u0437\u0443\u0447\u0435\u043d\u044b: {}", spellIds);
        }
    }

    @Override
    public boolean hasSpell(String spellId) {
        boolean hasSpell = this.spells.contains(spellId);
        log.info("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430, \u0438\u0437\u0443\u0447\u0435\u043d\u043e \u043b\u0438 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435 {}: {}", (Object)spellId, (Object)hasSpell);
        return hasSpell;
    }

    @Override
    public void removeSpell(String spellId) {
        if (this.spells.remove(spellId)) {
            SEComponents.SPELLS.sync((Object)this.obj);
            log.info("\u0423\u0434\u0430\u043b\u0435\u043d\u043e \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435: {}. \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a: {}", (Object)spellId, this.spells);
        } else {
            log.warn("\u0417\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435 {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0438\u0441\u043a\u0435.", (Object)spellId);
        }
    }

    @Override
    public void removeSpells(List<String> spellsId) {
        this.spells.removeAll(spellsId);
        SEComponents.SPELLS.sync((Object)this.obj);
    }

    @Override
    public void clearSpells() {
        this.spells.clear();
        SEComponents.SPELLS.sync((Object)this.obj);
        log.info("\u0417\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438\u0433\u0440\u043e\u043a\u0430 \u043e\u0447\u0438\u0449\u0435\u043d\u044b.");
    }

    @Override
    public List<String> getSpells() {
        return new ArrayList<String>(this.spells);
    }

    public void readFromNbt(class_2487 tag) {
        this.spells.clear();
        class_2499 nbtList = tag.method_10554(NBT_KEY_SPELL_IDS, 8);
        for (int i = 0; i < nbtList.size(); ++i) {
            this.spells.add(nbtList.method_10608(i));
        }
        log.info("\u0417\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438\u0433\u0440\u043e\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0438\u0437 NBT: {}", this.spells);
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 nbtList = new class_2499();
        for (String spell : this.spells) {
            nbtList.add((Object)class_2519.method_23256((String)spell));
        }
        tag.method_10566(NBT_KEY_SPELL_IDS, (class_2520)nbtList);
        log.info("\u0417\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438\u0433\u0440\u043e\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b \u0432 NBT: {}", this.spells);
    }

    public boolean hasAnySpells(List<String> spellIds) {
        boolean result = this.spells.stream().anyMatch(spellIds::contains);
        log.info("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430, \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043b\u0438 \u0438\u0433\u0440\u043e\u043a \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u043d\u043e \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435 \u0438\u0437 {}: {}", spellIds, (Object)result);
        return result;
    }

    public static enum ContentType {
        MAGIC,
        ARCHERY;

    }
}

