/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic;

public class FluidFilterContainer {
    private final Player player;
    private final IServerUpdater serverUpdater;
    private final Supplier<FluidFilterLogic> fluidFilterLogic;
    private static final String DATA_FLUID = "setFluid";

    public FluidFilterContainer(Player player, IServerUpdater serverUpdater, Supplier<FluidFilterLogic> fluidFilterLogic) {
        this.player = player;
        this.serverUpdater = serverUpdater;
        this.fluidFilterLogic = fluidFilterLogic;
    }

    public FluidStack getFluid(int index) {
        return this.fluidFilterLogic.get().getFluid(index);
    }

    private void setFluid(int index, FluidStack fluid) {
        this.fluidFilterLogic.get().setFluid(index, fluid);
        this.serverUpdater.sendDataToServer(() -> this.serializeSetFluidData(index, fluid));
    }

    private CompoundTag serializeSetFluidData(int index, FluidStack fluid) {
        CompoundTag ret = new CompoundTag();
        CompoundTag fluidNbt = new CompoundTag();
        fluidNbt.m_128405_("index", index);
        fluidNbt.m_128365_("fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
        ret.m_128365_(DATA_FLUID, (Tag)fluidNbt);
        return ret;
    }

    public boolean handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_FLUID)) {
            CompoundTag fluidData = data.m_128469_(DATA_FLUID);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)fluidData.m_128469_("fluid"));
            this.setFluid(fluidData.m_128451_("index"), fluid);
            return true;
        }
        return false;
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilterLogic.get().getNumberOfFluidFilters();
    }

    public void slotClick(int index) {
        ItemStack carried = this.player.f_36096_.m_142621_();
        if (carried.m_41619_()) {
            this.setFluid(index, FluidStack.EMPTY);
            return;
        }
        carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(itemFluidHandler -> {
            FluidStack containedFluid = itemFluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!containedFluid.isEmpty()) {
                this.setFluid(index, containedFluid);
            }
        });
    }
}

