/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class ItemDisplaySettingsCategory
implements ISettingsCategory<ItemDisplaySettingsCategory>,
ISlotColorCategory {
    public static final String NAME = "item_display";
    private static final String SLOT_TAG = "slot";
    private static final String ROTATION_TAG = "rotation";
    private static final String SLOTS_TAG = "slots";
    private static final String ROTATIONS_TAG = "rotations";
    private static final String COLOR_TAG = "color";
    private static final String DISPLAY_SIDE_TAG = "displaySide";
    private final Supplier<InventoryHandler> inventoryHandlerSupplier;
    private final Supplier<RenderInfo> renderInfoSupplier;
    private CompoundTag categoryNbt;
    private final Consumer<CompoundTag> saveNbt;
    private final int itemNumberLimit;
    private final Supplier<MemorySettingsCategory> getMemorySettings;
    private DyeColor color = DyeColor.RED;
    private final List<Integer> slotIndexes = new LinkedList<Integer>();
    private Map<Integer, Integer> slotRotations = new HashMap<Integer, Integer>();
    private DisplaySide displaySide = DisplaySide.FRONT;

    public ItemDisplaySettingsCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier, CompoundTag categoryNbt, Consumer<CompoundTag> saveNbt, int itemNumberLimit, Supplier<MemorySettingsCategory> getMemorySettings) {
        this.inventoryHandlerSupplier = inventoryHandlerSupplier;
        this.renderInfoSupplier = renderInfoSupplier;
        this.categoryNbt = categoryNbt;
        this.saveNbt = saveNbt;
        this.itemNumberLimit = itemNumberLimit;
        this.getMemorySettings = getMemorySettings;
        this.deserialize();
    }

    public int getItemNumberLimit() {
        return this.itemNumberLimit;
    }

    public void unselectSlot(int slotIndex) {
        int orderIndex = this.slotIndexes.indexOf(slotIndex);
        this.slotIndexes.remove(orderIndex);
        this.slotRotations.remove(slotIndex);
        if (this.slotIndexes.isEmpty()) {
            this.categoryNbt.m_128473_(SLOTS_TAG);
            this.categoryNbt.m_128473_(ROTATIONS_TAG);
        }
        this.serializeSlotIndexes();
        this.updateFullRenderInfo();
    }

    private boolean haveRenderedItemsChanged() {
        List<RenderInfo.DisplayItem> previousDisplayItems = this.renderInfoSupplier.get().getItemDisplayRenderInfo().getDisplayItems();
        List<Integer> inaccessibleSlots = this.renderInfoSupplier.get().getItemDisplayRenderInfo().getInaccessibleSlots();
        if (previousDisplayItems.size() != this.slotIndexes.size()) {
            return true;
        }
        int i = 0;
        InventoryHandler inventoryHandler = this.inventoryHandlerSupplier.get();
        for (int slotIndex : this.slotIndexes) {
            ItemStack newItem = this.getSlotItemCopy(slotIndex).orElse(ItemStack.f_41583_);
            if (ItemStackKey.getHashCode(newItem) != ItemStackKey.getHashCode(previousDisplayItems.get(i).getItem()) || inaccessibleSlots.contains(slotIndex) == inventoryHandler.isSlotAccessible(slotIndex)) {
                return true;
            }
            ++i;
        }
        if (this.renderInfoSupplier.get().showsCountsAndFillRatios()) {
            List<Integer> previousSlotCounts = this.renderInfoSupplier.get().getItemDisplayRenderInfo().getSlotCounts();
            List<Float> previousSlotFillRatios = this.renderInfoSupplier.get().getItemDisplayRenderInfo().getSlotFillRatios();
            List<Integer> previousInfiniteSlots = this.renderInfoSupplier.get().getItemDisplayRenderInfo().getInfiniteSlots();
            if (previousSlotCounts.size() != inventoryHandler.getSlots() || previousSlotFillRatios.size() != inventoryHandler.getSlots()) {
                return true;
            }
            for (int slotIndex = 0; slotIndex < inventoryHandler.getSlots(); ++slotIndex) {
                int previousSlotCount = previousSlotCounts.get(slotIndex);
                float previousSlotFillRatio = previousSlotFillRatios.get(slotIndex).floatValue();
                ItemStack stack = inventoryHandler.getStackInSlot(slotIndex);
                float currentSlotFillRatio = ItemDisplaySettingsCategory.calculateSlotFillRatio(stack, inventoryHandler, slotIndex);
                if (previousSlotCount == stack.m_41613_() && previousInfiniteSlots.contains(slotIndex) == inventoryHandler.isInfinite(slotIndex) && MathHelper.epsilonEquals(previousSlotFillRatio, currentSlotFillRatio)) continue;
                return true;
            }
        }
        return i != previousDisplayItems.size();
    }

    private void updateFullRenderInfo() {
        ArrayList<RenderInfo.DisplayItem> displayItems = new ArrayList<RenderInfo.DisplayItem>();
        ArrayList<Integer> inaccessibleSlots = new ArrayList<Integer>();
        InventoryHandler inventoryHandler = this.inventoryHandlerSupplier.get();
        for (int slotIndex : this.slotIndexes) {
            displayItems.add(new RenderInfo.DisplayItem(this.getSlotItemCopy(slotIndex).orElse(ItemStack.f_41583_), this.slotRotations.getOrDefault(slotIndex, 0), slotIndex, this.displaySide));
            if (inventoryHandler.isSlotAccessible(slotIndex)) continue;
            inaccessibleSlots.add(slotIndex);
        }
        ArrayList<Integer> slotCounts = new ArrayList<Integer>();
        ArrayList<Float> slotFillRatios = new ArrayList<Float>();
        ArrayList<Integer> infiniteSlots = new ArrayList<Integer>();
        if (this.renderInfoSupplier.get().showsCountsAndFillRatios()) {
            for (int slotIndex = 0; slotIndex < inventoryHandler.getSlots(); ++slotIndex) {
                ItemStack stack = inventoryHandler.getStackInSlot(slotIndex);
                slotCounts.add(stack.m_41613_());
                slotFillRatios.add(Float.valueOf(ItemDisplaySettingsCategory.calculateSlotFillRatio(stack, inventoryHandler, slotIndex)));
                if (!inventoryHandler.isInfinite(slotIndex)) continue;
                infiniteSlots.add(slotIndex);
            }
        }
        this.renderInfoSupplier.get().refreshItemDisplayRenderInfo(displayItems, inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
    }

    private static float calculateSlotFillRatio(ItemStack stack, InventoryHandler inventoryHandler, int slotIndex) {
        return stack.m_41619_() ? 0.0f : (float)stack.m_41613_() / (float)inventoryHandler.getStackLimit(slotIndex, stack);
    }

    private Optional<ItemStack> getSlotItemCopy(int slotIndex) {
        ItemStack slotStack = this.inventoryHandlerSupplier.get().getStackInSlot(slotIndex);
        if (slotStack.m_41619_()) {
            Item filterItem = this.inventoryHandlerSupplier.get().getFilterItem(slotIndex);
            if (filterItem != Items.f_41852_) {
                return Optional.of(new ItemStack((ItemLike)filterItem));
            }
            return this.getMemorySettings.get().getSlotFilterStack(slotIndex, true);
        }
        ItemStack stackCopy = slotStack.m_41777_();
        stackCopy.m_41764_(1);
        return Optional.of(stackCopy);
    }

    public void selectSlot(int slotIndex) {
        if (this.slotIndexes.size() + 1 > this.itemNumberLimit) {
            return;
        }
        this.slotIndexes.add(slotIndex);
        this.serializeSlotIndexes();
        this.updateFullRenderInfo();
    }

    private void serializeSlotIndexes() {
        this.categoryNbt.m_128408_(SLOTS_TAG, this.slotIndexes);
        this.saveNbt.accept(this.categoryNbt);
    }

    public List<Integer> getSlots() {
        return this.slotIndexes;
    }

    public int getRotation(int slotIndex) {
        return this.slotRotations.getOrDefault(slotIndex, 0);
    }

    public void rotate(int slotIndex, boolean clockwise) {
        if (!this.slotIndexes.contains(slotIndex)) {
            return;
        }
        int rotation = this.getRotation(slotIndex);
        rotation = (rotation + (clockwise ? 1 : -1) * 45 + 360) % 360;
        this.slotRotations.put(slotIndex, rotation);
        this.serializeRotations();
        this.updateFullRenderInfo();
    }

    private void serializeRotations() {
        NBTHelper.putMap(this.categoryNbt, ROTATIONS_TAG, this.slotRotations, String::valueOf, IntTag::m_128679_);
        this.saveNbt.accept(this.categoryNbt);
    }

    public void setColor(DyeColor color) {
        this.color = color;
        this.categoryNbt.m_128405_(COLOR_TAG, color.m_41060_());
        this.saveNbt.accept(this.categoryNbt);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public DisplaySide getDisplaySide() {
        return this.displaySide;
    }

    public void setDisplaySide(DisplaySide displaySide) {
        this.displaySide = displaySide;
        this.categoryNbt.m_128359_(DISPLAY_SIDE_TAG, displaySide.m_7912_());
        this.saveNbt.accept(this.categoryNbt);
        this.updateFullRenderInfo();
    }

    @Override
    public void reloadFrom(CompoundTag categoryNbt) {
        this.categoryNbt = categoryNbt;
        this.deserialize();
    }

    @Override
    public void overwriteWith(ItemDisplaySettingsCategory otherCategory) {
        this.slotIndexes.clear();
        this.slotIndexes.addAll(otherCategory.getSlots());
        this.serializeSlotIndexes();
        this.slotRotations.clear();
        this.slotRotations.putAll(otherCategory.slotRotations);
        this.serializeRotations();
        this.setColor(otherCategory.getColor());
        this.itemsChanged();
    }

    private void deserialize() {
        this.slotIndexes.clear();
        NBTHelper.getIntArray(this.categoryNbt, SLOTS_TAG).ifPresent(slots -> {
            for (int slot : slots) {
                this.slotIndexes.add(slot);
            }
        });
        this.slotRotations = NBTHelper.getMap(this.categoryNbt, ROTATIONS_TAG, Integer::valueOf, (k, v) -> Optional.of(((IntTag)v).m_7047_())).orElseGet(HashMap::new);
        this.color = NBTHelper.getInt(this.categoryNbt, COLOR_TAG).map(DyeColor::m_41053_).orElse(DyeColor.RED);
        NBTHelper.getInt(this.categoryNbt, SLOT_TAG).ifPresent(e -> {
            this.slotIndexes.add((Integer)e);
            this.categoryNbt.m_128473_(SLOT_TAG);
            this.serializeSlotIndexes();
        });
        NBTHelper.getInt(this.categoryNbt, ROTATION_TAG).ifPresent(r -> {
            if (!this.slotIndexes.isEmpty()) {
                this.slotRotations.put(this.slotIndexes.iterator().next(), (Integer)r);
            }
            this.categoryNbt.m_128473_(ROTATION_TAG);
            this.serializeRotations();
        });
        NBTHelper.getEnumConstant(this.categoryNbt, DISPLAY_SIDE_TAG, DisplaySide::fromName).ifPresent(ds -> {
            this.displaySide = ds;
        });
    }

    public void itemChanged(int changedSlotIndex) {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER || !this.slotIndexes.contains(changedSlotIndex)) {
            return;
        }
        if (this.haveRenderedItemsChanged()) {
            this.updateFullRenderInfo();
        }
    }

    public void itemsChanged() {
        if (this.haveRenderedItemsChanged()) {
            this.updateFullRenderInfo();
        }
    }

    @Override
    public Optional<Integer> getSlotColor(int slotNumber) {
        return this.slotIndexes.contains(slotNumber) ? Optional.of(ColorHelper.getColor(this.color.m_41068_())) : Optional.empty();
    }

    public void selectSlots(int minSlot, int maxSlot) {
        for (int slotIndex = minSlot; slotIndex < maxSlot; ++slotIndex) {
            if (this.slotIndexes.size() + 1 > this.itemNumberLimit) {
                return;
            }
            this.slotIndexes.add(slotIndex);
        }
        this.serializeSlotIndexes();
        this.updateFullRenderInfo();
    }

    @Override
    public boolean isLargerThanNumberOfSlots(int slots) {
        return this.slotIndexes.stream().anyMatch(slotIndex -> slotIndex >= slots);
    }

    @Override
    public void copyTo(ItemDisplaySettingsCategory otherCategory, int startFromSlot, int slotOffset) {
    }

    @Override
    public void deleteSlotSettingsFrom(int slotIndex) {
        this.slotIndexes.removeIf(slot -> slot >= slotIndex);
        this.serializeSlotIndexes();
    }
}

