/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.screen.textbox;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.scholar.screen.textbox.DisplayCache;
import io.github.mortuusars.scholar.screen.textbox.HorizontalAlignment;
import io.github.mortuusars.scholar.screen.textbox.Pos2i;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TextBox
extends AbstractWidget {
    public final Font font;
    public Supplier<String> textGetter;
    public Consumer<String> textSetter;
    public Predicate<String> textValidator = text -> {
        int n;
        if (text == null) return false;
        int n2 = this.getFont().m_92920_(text, this.f_93618_);
        if (text.endsWith("\n")) {
            Objects.requireNonNull(this.getFont());
            n = 9;
        } else {
            n = 0;
        }
        if (n2 + n > this.f_93619_) return false;
        return true;
    };
    public HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    public int fontColor = -16777216;
    public int fontUnfocusedColor = -16777216;
    public int selectionColor = -16776961;
    public int selectionUnfocusedColor = -2013265665;
    public final TextFieldHelper textFieldHelper;
    protected DisplayCache displayCache = new DisplayCache();
    protected int frameTick;
    protected long lastClickTime;
    protected int lastIndex = -1;

    public TextBox(@NotNull Font font, int x, int y, int width, int height, Supplier<String> textGetter, Consumer<String> textSetter) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.font = font;
        this.textGetter = textGetter;
        this.textSetter = textSetter;
        this.textFieldHelper = new TextFieldHelper(this::getText, this::setText, TextFieldHelper.m_95153_((Minecraft)Minecraft.m_91087_()), TextFieldHelper.m_95182_((Minecraft)Minecraft.m_91087_()), this::validateText);
    }

    public void tick() {
        ++this.frameTick;
    }

    public Font getFont() {
        return this.font;
    }

    @NotNull
    public String getText() {
        return this.textGetter.get();
    }

    public TextBox setText(@NotNull String text) {
        this.textSetter.accept(text);
        this.clearDisplayCache();
        return this;
    }

    protected boolean validateText(String text) {
        return this.textValidator.test(text);
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
        this.clearDisplayCache();
    }

    public TextFieldHelper getTextHandler() {
        return this.textFieldHelper;
    }

    public int getCurrentFontColor() {
        return this.m_93696_() ? this.fontColor : this.fontUnfocusedColor;
    }

    public TextBox setFontColor(int fontColor, int fontUnfocusedColor) {
        this.fontColor = fontColor;
        this.fontUnfocusedColor = fontUnfocusedColor;
        this.clearDisplayCache();
        return this;
    }

    public TextBox setSelectionColor(int selectionColor, int selectionUnfocusedColor) {
        this.selectionColor = selectionColor;
        this.selectionUnfocusedColor = selectionUnfocusedColor;
        this.clearDisplayCache();
        return this;
    }

    public void setCursorToEnd() {
        this.textFieldHelper.m_95193_();
        this.clearDisplayCache();
    }

    public void refresh() {
        this.clearDisplayCache();
    }

    protected DisplayCache getDisplayCache() {
        if (this.displayCache.needsRebuilding) {
            this.displayCache.rebuild(this.font, this.getText(), this.textFieldHelper.m_95194_(), this.textFieldHelper.m_95197_(), this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), this.horizontalAlignment);
        }
        return this.displayCache;
    }

    protected void clearDisplayCache() {
        this.displayCache.needsRebuilding = true;
    }

    protected Pos2i convertLocalToScreen(Pos2i pos) {
        return new Pos2i(this.m_252754_() + pos.x, this.m_252907_() + pos.y);
    }

    protected Pos2i convertScreenToLocal(Pos2i screenPos) {
        return new Pos2i(screenPos.x - this.m_252754_(), screenPos.y - this.m_252907_());
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        DisplayCache displayCache = this.getDisplayCache();
        for (DisplayCache.LineInfo lineInfo : displayCache.lines) {
            guiGraphics.m_280614_(this.font, lineInfo.asComponent, this.m_252754_() + lineInfo.x, this.m_252907_() + lineInfo.y, this.getCurrentFontColor(), false);
        }
        this.renderHighlight(guiGraphics, displayCache.selectionAreas);
        if (this.m_93696_()) {
            this.renderCursor(guiGraphics, displayCache.cursorPos, displayCache.cursorAtEnd);
        }
    }

    protected void renderHighlight(GuiGraphics guiGraphics, Rect2i[] highlightAreas) {
        for (Rect2i selection : highlightAreas) {
            int x = this.m_252754_() + selection.m_110085_();
            int y = this.m_252907_() + selection.m_110086_();
            int x1 = x + selection.m_110090_();
            int y1 = y + selection.m_110091_();
            guiGraphics.m_285944_(RenderType.m_285783_(), x, y - 1, x1, y1, this.m_93696_() ? this.selectionColor : this.selectionUnfocusedColor);
        }
    }

    protected void renderCursor(GuiGraphics guiGraphics, Pos2i cursorPos, boolean isEndOfText) {
        if (this.frameTick / 6 % 2 == 0) {
            cursorPos = this.convertLocalToScreen(cursorPos);
            if (isEndOfText) {
                guiGraphics.m_280056_(this.font, "_", cursorPos.x, cursorPos.y, this.getCurrentFontColor(), false);
            } else {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
                RenderSystem.disableBlend();
                int n = cursorPos.x;
                int n2 = cursorPos.y - 1;
                int n3 = cursorPos.x + 1;
                int n4 = cursorPos.y;
                Objects.requireNonNull(this.font);
                guiGraphics.m_280509_(n, n2, n3, n4 + 9, this.getCurrentFontColor());
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    @NotNull
    public Component m_6035_() {
        return Component.m_237113_((String)this.getText());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_93696_()) {
            return false;
        }
        boolean handled = this.handleKeyPressed(keyCode, scanCode, modifiers);
        if (handled) {
            this.clearDisplayCache();
        }
        return handled;
    }

    protected boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        TextFieldHelper.CursorStep cursorStep;
        TextFieldHelper.CursorStep cursorStep2 = cursorStep = Screen.m_96637_() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        if (keyCode == 265) {
            this.changeLine(-1);
            return true;
        }
        if (keyCode == 264) {
            this.changeLine(1);
            return true;
        }
        if (keyCode == 268) {
            this.keyHome();
            return true;
        }
        if (keyCode == 269) {
            this.keyEnd();
            return true;
        }
        if (keyCode == 259) {
            this.textFieldHelper.m_232572_(-1, cursorStep);
            return true;
        }
        if (keyCode == 261) {
            this.textFieldHelper.m_232572_(1, cursorStep);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.textFieldHelper.m_95158_(CommonComponents.f_178388_.getString());
            return true;
        }
        return this.textFieldHelper.m_95145_(keyCode);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.m_93696_()) {
            return false;
        }
        boolean typed = this.textFieldHelper.m_95143_(codePoint);
        if (typed) {
            this.clearDisplayCache();
        }
        return typed;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93622_ && this.f_93624_ && this.m_142518_() && button == 0) {
            long currentTime = Util.m_137550_();
            DisplayCache displayCache = this.getDisplayCache();
            int index = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (index >= 0) {
                if (index == this.lastIndex && currentTime - this.lastClickTime < 250L) {
                    if (!this.textFieldHelper.m_95198_()) {
                        this.selectWord(index);
                    } else {
                        this.textFieldHelper.m_95188_();
                    }
                } else {
                    this.textFieldHelper.m_95179_(index, Screen.m_96638_());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = index;
            this.lastClickTime = currentTime;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            DisplayCache displayCache = this.getDisplayCache();
            int index = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            this.textFieldHelper.m_95179_(index, true);
            this.clearDisplayCache();
        }
        return true;
    }

    protected void selectWord(int index) {
        String string = this.getText();
        this.textFieldHelper.m_95147_(StringSplitter.m_92355_((String)string, (int)-1, (int)index, (boolean)false), StringSplitter.m_92355_((String)string, (int)1, (int)index, (boolean)false));
    }

    protected void changeLine(int yChange) {
        int cursorPos = this.textFieldHelper.m_95194_();
        int line = this.getDisplayCache().changeLine(cursorPos, yChange);
        this.textFieldHelper.m_95179_(line, Screen.m_96638_());
    }

    protected void keyHome() {
        if (Screen.m_96637_()) {
            this.textFieldHelper.m_95176_(Screen.m_96638_());
        } else {
            int cursorIndex = this.textFieldHelper.m_95194_();
            int lineStartIndex = this.getDisplayCache().findLineStart(cursorIndex);
            this.textFieldHelper.m_95179_(lineStartIndex, Screen.m_96638_());
        }
    }

    protected void keyEnd() {
        if (Screen.m_96637_()) {
            this.textFieldHelper.m_95186_(Screen.m_96638_());
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            int cursorIndex = this.textFieldHelper.m_95194_();
            int lineEndIndex = displayCache.findLineEnd(cursorIndex);
            this.textFieldHelper.m_95179_(lineEndIndex, Screen.m_96638_());
        }
    }
}

