/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.menu;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.util.BookHelper;
import io.github.mortuusars.scholar.visual.BookColors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.LecternMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LecternSpreadMenu
extends LecternMenu {
    public static final int PREV_PAGE_ID = 1;
    public static final int NEXT_PAGE_ID = 2;
    private final int bookColor;
    private final int spreads;

    public LecternSpreadMenu(int containerId, Container lectern, ContainerData lecternData, int bookColor) {
        super(containerId, lectern, lecternData);
        this.bookColor = bookColor;
        this.spreads = (int)Math.ceil((float)BookHelper.getPageCount(this.m_39835_()) / 2.0f);
        if (this.m_39836_() % 2 != 0) {
            int correctedPage = Mth.m_14045_((int)(this.m_39836_() - 1), (int)0, (int)98);
            this.m_7511_(0, correctedPage);
        }
    }

    public static LecternSpreadMenu fromBuffer(int containerId, Inventory inventory, FriendlyByteBuf buffer) {
        ItemStack bookStack = buffer.m_130267_();
        int bookColor = BookColors.fromStack(bookStack);
        return new LecternSpreadMenu(containerId, (Container)new SimpleContainer(new ItemStack[]{bookStack}), (ContainerData)new SimpleContainerData(1), bookColor);
    }

    public int getBookColor() {
        return this.bookColor;
    }

    @NotNull
    public MenuType<?> m_6772_() {
        return Scholar.MenuTypes.LECTERN.get();
    }

    public boolean m_6366_(Player player, int buttonId) {
        if (buttonId == 1 || buttonId == 2) {
            int change;
            int currentSpread = this.getCurrentSpread();
            int newSpreadIndex = currentSpread + (change = buttonId == 1 ? -1 : 1);
            if (newSpreadIndex < 0 || newSpreadIndex + 1 > this.spreads) {
                return true;
            }
            int newPageIndex = newSpreadIndex * 2;
            this.m_7511_(0, newPageIndex);
            return true;
        }
        return super.m_6366_(player, buttonId);
    }

    protected int getCurrentSpread() {
        return this.m_39836_() / 2;
    }
}

