/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.ai.goal;

import com.teamabnormals.savage_and_ravage.common.entity.OwnableMob;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FollowMobOwnerGoal
extends Goal {
    private final Mob ownedMob;
    private LivingEntity owner;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float minDist;
    private final float maxDist;
    private float oldWaterCost;

    public FollowMobOwnerGoal(Mob entityIn, double followSpeed, float minimumDistance, float maximumDistance) {
        this.ownedMob = entityIn;
        this.followSpeed = followSpeed;
        this.navigator = entityIn.m_21573_();
        this.minDist = minimumDistance;
        this.maxDist = maximumDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(entityIn.m_21573_() instanceof GroundPathNavigation) && !(entityIn.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity livingentity = ((OwnableMob)this.ownedMob).getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.ownedMob.m_20280_((Entity)livingentity) <= (double)(this.minDist * this.minDist) || this.ownedMob.m_20280_((Entity)livingentity) >= (double)(this.maxDist * this.maxDist)) {
            return false;
        }
        if (this.ownedMob.m_5448_() != null) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigator.m_26571_()) {
            return false;
        }
        if (this.ownedMob.m_20280_((Entity)this.owner) <= (double)(this.minDist * this.minDist) || this.ownedMob.m_20280_((Entity)this.owner) >= (double)(this.maxDist * this.maxDist)) {
            return false;
        }
        return this.ownedMob.m_5448_() == null;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.ownedMob.m_21439_(BlockPathTypes.WATER);
        this.ownedMob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigator.m_26573_();
        this.ownedMob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.ownedMob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.ownedMob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.ownedMob.m_21523_() && !this.ownedMob.m_20159_()) {
                this.navigator.m_5624_((Entity)this.owner, this.followSpeed);
            }
        }
    }
}

