/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.sanguine_arsenal.items.swords;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import elucent.eidolon.common.item.IRechargeableWand;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import ru.blatfan.sanguine_arsenal.core.SangArsConfig;
import ru.blatfan.sanguine_arsenal.core.Util.BloodUtil;
import ru.blatfan.sanguine_arsenal.core.Util.LivingUtil;
import ru.blatfan.sanguine_arsenal.core.init.SangArsTiers;
import ru.blatfan.sanguine_arsenal.entities.FlyingScytheEntity;

public class PraetorScythe
extends SwordItem
implements IRechargeableWand {
    public PraetorScythe(Item.Properties props) {
        super((Tier)SangArsTiers.PRAETOR_SCYTHE, 0, 0.0f, props);
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1080;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(Item.f_41374_, "Weapon modifier", (double)((Integer)SangArsConfig.COMMON.praetorScytheMeleeDamage.get()).intValue(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(Item.f_41375_, "Weapon modifier", ((Double)SangArsConfig.COMMON.praetorScytheAttackSpeed.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        ImmutableMultimap defaultModifiers = builder.build();
        return slot == EquipmentSlot.MAINHAND ? defaultModifiers : super.m_7167_(slot);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand handIn) {
        ItemStack stack = playerEntity.m_21120_(handIn);
        if (!LivingUtil.hasFullSPSet(playerEntity) && !playerEntity.m_7500_()) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"sanguine_arsenal.no_praetor_armor"), true);
        }
        if (!BloodUtil.hasBloodFlask(playerEntity) && !playerEntity.m_7500_()) {
            playerEntity.m_5661_((Component)Component.m_237115_((String)"sanguine_arsenal.no_blood_flask"), true);
        }
        if (!world.f_46443_ && LivingUtil.hasFullSPSet(playerEntity) && BloodUtil.hasBloodFlask(playerEntity) || playerEntity.m_7500_()) {
            EquipmentSlot hand = handIn == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
            playerEntity.m_8061_(hand, ItemStack.f_41583_);
            double baseDamage = playerEntity.m_21133_(Attributes.f_22281_);
            float multiplier = 1.2f;
            double damage = 1.0 + baseDamage * (double)multiplier;
            int slot = playerEntity.m_150109_().f_35977_;
            FlyingScytheEntity entity = new FlyingScytheEntity(world);
            entity.m_6034_(playerEntity.m_20185_(), playerEntity.m_20186_() + (double)(playerEntity.m_20206_() / 2.0f), playerEntity.m_20189_());
            entity.setData((float)damage, playerEntity.m_20148_(), slot, stack);
            entity.m_20088_().m_135381_(FlyingScytheEntity.SCYTHE, (Object)stack);
            entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 1.5f, 0.0f);
            world.m_7967_((Entity)entity);
        }
        playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        return super.m_7203_(world, playerEntity, handIn);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player attacker, Entity target) {
        if (target instanceof LivingEntity) {
            float damage = (float)attacker.m_21133_(Attributes.f_22281_);
            for (LivingEntity livingentity : attacker.m_9236_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(1.0, 0.25, 1.0))) {
                if (livingentity == attacker || livingentity == target || attacker.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(attacker.m_20280_((Entity)livingentity) < 9.0)) continue;
                livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
                ResourceKey damageTypeResourceKey = DamageTypes.f_268464_;
                Holder.Reference holder = attacker.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(damageTypeResourceKey);
                DamageSource damageSource = new DamageSource((Holder)holder);
                livingentity.m_6469_(damageSource, damage);
            }
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
            attacker.m_36346_();
        }
        stack.m_41622_(1, (LivingEntity)attacker, e -> attacker.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_())));
        return super.onLeftClickEntity(stack, attacker, target);
    }

    public ItemStack recharge(ItemStack stack) {
        stack.m_41721_(0);
        return stack;
    }
}

