/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.sanguine_arsenal.armor.sanguinepraetor;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import ru.blatfan.sanguine_arsenal.armor.sanguinepraetor.SPArmorRenderer;
import ru.blatfan.sanguine_arsenal.core.SangArsConfig;
import ru.blatfan.sanguine_arsenal.core.Util.BloodUtil;
import ru.blatfan.sanguine_arsenal.core.Util.LivingUtil;
import ru.blatfan.sanguine_arsenal.core.init.ItemInit;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SPArmorItem
extends ArmorItem
implements GeoItem {
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SPArmorItem(ArmorItem.Type slot, Item.Properties builderIn) {
        super((net.minecraft.world.item.ArmorMaterial)ArmorMaterial.SHADOW_INFUSED, slot, builderIn);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (stack.m_41720_() != ItemInit.SP_CHESTPLATE.get()) {
            return;
        }
        if (!LivingUtil.hasFullSPSet(player)) {
            return;
        }
        BloodUtil.addDimensionEffects(level, player, (Integer)SangArsConfig.COMMON.praetorEffectMultiplier.get(), 81);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private SPArmorRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new SPArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "armor", 0, event -> PlayState.STOP)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum ArmorMaterial implements net.minecraft.world.item.ArmorMaterial
    {
        SHADOW_INFUSED(new int[]{2, 5, 6, 2}, () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemInit.SHADOW_INFUSED_INGOT.get())}));

        private static final int[] HEALTH_PER_SLOT;
        private final String name;
        private final int durabilityMultiplier;
        private final int[] slotProtections;
        private final int enchantmentValue;
        private final SoundEvent sound;
        private final float toughness;
        private final float knockbackResistance;
        private final Supplier<Ingredient> repairIngredient;

        private ArmorMaterial(int[] p_i231593_5_, Supplier<Ingredient> repairIngredient) {
            this.name = "sanguine_praetor";
            this.durabilityMultiplier = 14;
            this.slotProtections = p_i231593_5_;
            this.enchantmentValue = 15;
            this.sound = SoundEvents.f_11679_;
            this.toughness = 1.0f;
            this.knockbackResistance = 0.0f;
            this.repairIngredient = repairIngredient;
        }

        public int m_266425_(ArmorItem.Type type) {
            if (type == ArmorItem.Type.HELMET) {
                return HEALTH_PER_SLOT[3] * this.durabilityMultiplier;
            }
            if (type == ArmorItem.Type.CHESTPLATE) {
                return HEALTH_PER_SLOT[2] * this.durabilityMultiplier;
            }
            if (type == ArmorItem.Type.LEGGINGS) {
                return HEALTH_PER_SLOT[1] * this.durabilityMultiplier;
            }
            if (type == ArmorItem.Type.BOOTS) {
                return HEALTH_PER_SLOT[0] * this.durabilityMultiplier;
            }
            return 0;
        }

        public int m_7366_(ArmorItem.Type type) {
            if (type == ArmorItem.Type.HELMET) {
                return this.slotProtections[3];
            }
            if (type == ArmorItem.Type.CHESTPLATE) {
                return this.slotProtections[2];
            }
            if (type == ArmorItem.Type.LEGGINGS) {
                return this.slotProtections[1];
            }
            if (type == ArmorItem.Type.BOOTS) {
                return this.slotProtections[0];
            }
            return 0;
        }

        public int m_6646_() {
            return this.enchantmentValue;
        }

        public SoundEvent m_7344_() {
            return this.sound;
        }

        public Ingredient m_6230_() {
            return this.repairIngredient.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return this.knockbackResistance;
        }

        static {
            HEALTH_PER_SLOT = new int[]{26, 30, 32, 22};
        }
    }
}

