/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import dev.yurisuika.raised.client.RaisedOptions;
import dev.yurisuika.raised.client.gui.components.IconToggleButton;
import dev.yurisuika.raised.util.config.Option;
import dev.yurisuika.raised.util.properties.Element;
import dev.yurisuika.raised.util.properties.Position;
import dev.yurisuika.raised.util.properties.Sync;
import java.util.Arrays;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;

public class RaisedScreen
extends Screen {
    public StringWidget title;
    public StringWidget page;
    public IconToggleButton hotbar;
    public IconToggleButton chat;
    public IconToggleButton bossbar;
    public IconToggleButton sidebar;
    public IconToggleButton effects;
    public IconToggleButton players;
    public IconToggleButton toasts;
    public IconToggleButton other;
    public AbstractWidget x;
    public AbstractWidget y;
    public AbstractWidget position;
    public AbstractWidget sync;
    public double time = 0.0;
    public double duration = 25.0;
    public double distance = 0.0;
    public static Element element = Element.HOTBAR;

    public RaisedScreen(Component title) {
        super(title);
    }

    public void m_7856_() {
        this.title = new StringWidget((Component)Component.m_237115_((String)"options.raised.title"), this.f_96547_);
        this.page = new StringWidget((Component)Component.m_237115_((String)element.m_35968_()), this.f_96547_);
        this.title.m_93674_(this.f_96543_);
        this.title.m_264152_(0, 22);
        this.page.m_93674_(this.f_96543_);
        this.page.m_264152_(0, 47);
        this.m_142416_((GuiEventListener)this.title);
        this.m_142416_((GuiEventListener)this.page);
        this.createLayersGrid();
        this.createPropertiesGrid();
    }

    public void createLayersGrid() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.m_264211_().m_264129_(0, 0, 10, 5);
        GridLayout.RowHelper rowHelper = gridLayout.m_264606_(4);
        this.hotbar = this.createIconToggleButton(Element.HOTBAR);
        this.chat = this.createIconToggleButton(Element.CHAT);
        this.bossbar = this.createIconToggleButton(Element.BOSSBAR);
        this.sidebar = this.createIconToggleButton(Element.SIDEBAR);
        this.effects = this.createIconToggleButton(Element.EFFECTS);
        this.players = this.createIconToggleButton(Element.PLAYERS);
        this.toasts = this.createIconToggleButton(Element.TOASTS);
        this.other = this.createIconToggleButton(Element.OTHER);
        this.setIconToggleButton(this.hotbar);
        this.setIconToggleButton(this.chat);
        this.setIconToggleButton(this.bossbar);
        this.setIconToggleButton(this.sidebar);
        this.setIconToggleButton(this.effects);
        this.setIconToggleButton(this.players);
        this.setIconToggleButton(this.toasts);
        this.setIconToggleButton(this.other);
        rowHelper.m_264139_((LayoutElement)this.hotbar);
        rowHelper.m_264139_((LayoutElement)this.chat);
        rowHelper.m_264139_((LayoutElement)this.bossbar);
        rowHelper.m_264139_((LayoutElement)this.sidebar);
        rowHelper.m_264139_((LayoutElement)this.effects);
        rowHelper.m_264139_((LayoutElement)this.players);
        rowHelper.m_264139_((LayoutElement)this.toasts);
        rowHelper.m_264139_((LayoutElement)this.other);
        gridLayout.m_264036_();
        FrameLayout.m_264460_((LayoutElement)gridLayout, (int)16, (int)16, (int)this.f_96543_, (int)this.f_96544_, (float)0.0f, (float)0.0f);
        gridLayout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void createPropertiesGrid() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.m_264211_().m_264129_(10, 0, 0, 5);
        GridLayout.RowHelper rowHelper = gridLayout.m_264606_(4);
        this.x = new OptionInstance("options.raised.x", OptionInstance.m_231535_((Component)Component.m_237115_((String)"options.raised.x.tooltip")), (prefix, value) -> value == 0 ? Options.m_231921_((Component)prefix, (Component)CommonComponents.f_130654_) : Options.m_231921_((Component)prefix, (Component)Component.m_237113_((String)(Option.getX(element) + "px (" + Math.round(Math.ceil(value.floatValue() / ((float)this.f_96541_.m_91268_().m_85445_() / 4.0f) * 100.0f)) + "%)"))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, this.f_96541_.m_91268_().m_85445_() / 4), (Object)Option.getX(element), value -> Option.setX(element, value)).m_231507_(this.f_96541_.f_91066_, 0, 0, 110);
        this.y = new OptionInstance("options.raised.y", OptionInstance.m_231535_((Component)Component.m_237115_((String)"options.raised.y.tooltip")), (prefix, value) -> value == 0 ? Options.m_231921_((Component)prefix, (Component)CommonComponents.f_130654_) : Options.m_231921_((Component)prefix, (Component)Component.m_237113_((String)(Option.getY(element) + "px (" + Math.round(Math.ceil(value.floatValue() / ((float)this.f_96541_.m_91268_().m_85446_() / 4.0f) * 100.0f)) + "%)"))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, this.f_96541_.m_91268_().m_85446_() / 4), (Object)Option.getY(element), value -> Option.setY(element, value)).m_231507_(this.f_96541_.f_91066_, 0, 0, 110);
        this.position = new OptionInstance("options.raised.position", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"options.raised.position.tooltip")), OptionInstance.m_231546_(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Position.values()), Codec.INT.xmap(Position::byId, Position::m_35965_)), (Object)Position.byName(Option.getPosition(element).m_7912_()), value -> Option.setPosition(element, value)).m_231507_(this.f_96541_.f_91066_, 0, 0, 110);
        this.sync = new OptionInstance("options.raised.sync", value -> Tooltip.m_257550_((Component)Component.m_237110_((String)("options.raised.sync." + value.m_7912_() + ".tooltip"), (Object[])new Object[]{Component.m_237115_((String)element.m_35968_())})), OptionInstance.m_231546_(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Sync.values()), Codec.INT.xmap(Sync::byId, Sync::m_35965_)), (Object)Sync.byName(Option.getSync(element).m_7912_()), value -> Option.setSync(element, value)).m_231507_(this.f_96541_.f_91066_, 0, 0, 110);
        rowHelper.m_264108_((LayoutElement)this.x, 4);
        rowHelper.m_264108_((LayoutElement)this.y, 4);
        rowHelper.m_264108_((LayoutElement)this.position, 4);
        rowHelper.m_264108_((LayoutElement)this.sync, 4);
        gridLayout.m_264036_();
        FrameLayout.m_264460_((LayoutElement)gridLayout, (int)-16, (int)16, (int)this.f_96543_, (int)this.f_96544_, (float)1.0f, (float)0.0f);
        gridLayout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public IconToggleButton createIconToggleButton(Element element) {
        return IconToggleButton.builder((Component)Component.m_237115_((String)element.m_35968_()), button -> {
            RaisedScreen.element = element;
            this.f_96541_.m_91152_((Screen)new RaisedScreen((Component)Component.m_237115_((String)"options.raised.title")));
        }, element == RaisedScreen.element).size(20, 20).texture(ResourceLocation.m_135820_((String)("raised:textures/gui/icon/" + element.m_7912_() + ".png")), 20, 20).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)element.m_35968_()))).build();
    }

    public void setIconToggleButton(IconToggleButton widget) {
        widget.f_93623_ = !widget.toggled;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        double animation;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.x.f_93623_ = Option.getSync(element) == Sync.NONE;
        boolean bl = this.y.f_93623_ = Option.getSync(element) == Sync.NONE;
        if (Option.getX(element) > this.f_96541_.m_91268_().m_85445_() / 4) {
            Option.setX(element, this.f_96541_.m_91268_().m_85445_() / 4);
            this.f_96541_.m_91152_((Screen)new RaisedScreen((Component)Component.m_237115_((String)"options.raised.title")));
        }
        if (Option.getY(element) > this.f_96541_.m_91268_().m_85446_() / 4) {
            Option.setY(element, this.f_96541_.m_91268_().m_85446_() / 4);
            this.f_96541_.m_91152_((Screen)new RaisedScreen((Component)Component.m_237115_((String)"options.raised.title")));
        }
        if (this.time < this.duration) {
            this.time += (double)partialTick;
        }
        this.distance = (animation = Math.min(this.time / this.duration, this.duration)) < 0.36363636363636365 ? 7.5625 * animation * animation : (animation < 0.7272727272727273 ? 7.5625 * (animation -= 0.5454545454545454) * animation + 0.75 : (animation < 0.9090909090909091 ? 7.5625 * (animation -= 0.8181818181818182) * animation + 0.9375 : 7.5625 * (animation -= 0.9545454545454546) * animation + 0.984375));
        int x = Option.getX(Option.getSync(element) != Sync.NONE ? Element.byId(Option.getSync(element).m_35965_()) : element);
        int y = Option.getY(Option.getSync(element) != Sync.NONE ? Element.byId(Option.getSync(element).m_35965_()) : element);
        float percentX = (float)Math.round(Math.ceil((float)x / ((float)this.f_96541_.m_91268_().m_85445_() / 4.0f) * 100.0f)) / 100.0f;
        float percentY = (float)Math.round(Math.ceil((float)y / ((float)this.f_96541_.m_91268_().m_85446_() / 4.0f) * 100.0f)) / 100.0f;
        int offset = (int)((float)guiGraphics.m_280206_() / 2.0f) - y;
        String stringX = String.valueOf(x);
        String stringY = String.valueOf(y);
        int widthX = this.f_96547_.m_92895_(stringX);
        int widthY = this.f_96547_.m_92895_(stringY);
        MutableComponent translatableX = Component.m_237115_((String)"options.raised.x");
        MutableComponent translatableY = Component.m_237115_((String)"options.raised.y");
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
        guiGraphics.m_280168_().m_85837_(this.distance * 91.0, 0.0, 300.0);
        RenderSystem.enableBlend();
        switch (element) {
            case HOTBAR: {
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/widgets.png"), -182, offset - 22, 0, 0, 182, 22);
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/widgets.png"), -183 + Mth.m_269140_((float)percentX, (int)5, (int)8) * 20, offset - 23, 0, 22, 24, 24);
                guiGraphics.m_280480_(Items.f_42437_.m_7968_(), -59, offset - 19);
                guiGraphics.m_280480_(Items.f_42546_.m_7968_(), -39, offset - 19);
                guiGraphics.m_280302_(this.f_96547_, Items.f_42437_.m_7968_(), -59, offset - 19, stringX);
                guiGraphics.m_280302_(this.f_96547_, Items.f_42546_.m_7968_(), -39, offset - 19, stringY);
                break;
            }
            case CHAT: {
                int backgroundOpacity = (int)(255.0 * (Double)this.f_96541_.f_91066_.m_232104_().m_231551_());
                int textOpacity = (int)(255.0 * (Double)this.f_96541_.f_91066_.m_232098_().m_231551_() * (double)0.9f + (double)0.1f);
                guiGraphics.m_280509_(-91, offset - 9 - 9, 37, offset, backgroundOpacity << 24);
                guiGraphics.m_280488_(this.f_96547_, "<" + translatableX.getString() + "> " + x, -87, offset - 8 - 9, 0xFFFFFF + (textOpacity << 24));
                guiGraphics.m_280488_(this.f_96547_, "<" + translatableY.getString() + "> " + y, -87, offset - 8, 0xFFFFFF + (textOpacity << 24));
                break;
            }
            case BOSSBAR: {
                int progress;
                int width = Math.max(this.f_96547_.m_92852_((FormattedText)translatableX), this.f_96547_.m_92852_((FormattedText)translatableY));
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/bars.png"), -182, offset - 5 - 19, 0, 20, 182, 5);
                if (x > 0) {
                    progress = Mth.m_269140_((float)percentX, (int)91, (int)182);
                    guiGraphics.m_280411_(ResourceLocation.m_135820_((String)"textures/gui/bars.png"), -182, offset - 5 - 19, progress, 5, 0.0f, 25.0f, progress, 5, 256, 256);
                }
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/bars.png"), -182, offset - 5, 0, 60, 182, 5);
                if (y > 0) {
                    progress = Mth.m_269140_((float)percentY, (int)91, (int)182);
                    guiGraphics.m_280411_(ResourceLocation.m_135820_((String)"textures/gui/bars.png"), -182, offset - 5, progress, 5, 0.0f, 65.0f, progress, 5, 256, 256);
                }
                guiGraphics.m_280430_(this.f_96547_, (Component)translatableX, -83 + width / 2 - this.f_96547_.m_92852_((FormattedText)translatableX) / 2, offset - 5 - 9 - 19, 0xFFFFFF);
                guiGraphics.m_280430_(this.f_96547_, (Component)translatableY, -83 + width / 2 - this.f_96547_.m_92852_((FormattedText)translatableY) / 2, offset - 5 - 9, 0xFFFFFF);
                break;
            }
            case SIDEBAR: {
                MutableComponent title = Component.m_237115_((String)"options.raised.element.sidebar");
                int width = Math.max(2 + Math.max(this.f_96547_.m_92852_((FormattedText)translatableX), this.f_96547_.m_92852_((FormattedText)translatableY)) + 9 + Math.max(widthX, widthY), 2 + this.f_96547_.m_92852_((FormattedText)title));
                guiGraphics.m_280509_(-90, offset - 1 - 9 - 10 - 10, -90 + width, offset - 1 - 10 - 10, this.f_96541_.f_91066_.m_92170_(0.4f));
                guiGraphics.m_280509_(-90, offset - 1 - 10 - 10, -90 + width, offset - 1, this.f_96541_.f_91066_.m_92170_(0.3f));
                guiGraphics.m_280614_(this.f_96547_, (Component)title, -90 + width / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2, offset - 1 - 8 - 10 - 10, -1, false);
                guiGraphics.m_280614_(this.f_96547_, (Component)translatableX, -88, offset - 1 - 9 - 10, -1, false);
                guiGraphics.m_280614_(this.f_96547_, (Component)translatableY, -88, offset - 1 - 9, -1, false);
                guiGraphics.m_280056_(this.f_96547_, String.valueOf(x), -90 + width - widthX, offset - 1 - 9 - 10, -2142128, false);
                guiGraphics.m_280056_(this.f_96547_, String.valueOf(y), -90 + width - widthY, offset - 1 - 9, -2142128, false);
                break;
            }
            case EFFECTS: {
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/container/inventory.png"), -90, offset - 24 - 1, 141, 166, 24, 24);
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/container/inventory.png"), -65, offset - 24 - 1, 141, 166, 24, 24);
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, percentX);
                guiGraphics.m_280159_(-87, offset - 24 - 1 + 3, 0, 18, 18, this.f_96541_.m_91306_().m_118732_(MobEffects.f_19621_));
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, percentY);
                guiGraphics.m_280159_(-62, offset - 24 - 1 + 3, 0, 18, 18, this.f_96541_.m_91306_().m_118732_(MobEffects.f_19590_));
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case PLAYERS: {
                guiGraphics.m_280509_(-90, offset - 1 - 10 - 9, 54, offset - 1, Integer.MIN_VALUE);
                guiGraphics.m_280509_(-89, offset - 1 - 9 - 9, 54, offset - 1 - 1 - 9, this.f_96541_.f_91066_.m_92143_(0x20FFFFFF));
                guiGraphics.m_280509_(-89, offset - 1 - 9, 54, offset - 1 - 1, this.f_96541_.f_91066_.m_92143_(0x20FFFFFF));
                PlayerFaceRenderer.m_280029_((GuiGraphics)guiGraphics, (ResourceLocation)ResourceLocation.m_135820_((String)"textures/entity/player/wide/steve.png"), (int)-89, (int)(offset - 1 - 9 - 9), (int)8, (boolean)true, (boolean)false);
                PlayerFaceRenderer.m_280029_((GuiGraphics)guiGraphics, (ResourceLocation)ResourceLocation.m_135820_((String)"textures/entity/player/slim/alex.png"), (int)-89, (int)(offset - 1 - 9), (int)8, (boolean)true, (boolean)false);
                guiGraphics.m_280430_(this.f_96547_, (Component)translatableX, -80, offset - 1 - 9 - 9, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)translatableY, -80, offset - 1 - 9, -1);
                guiGraphics.m_280488_(this.f_96547_, stringX, 42 - widthX, offset - 1 - 9 - 9, -171);
                guiGraphics.m_280488_(this.f_96547_, stringY, 42 - widthY, offset - 1 - 9, -171);
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/icons.png"), 43, offset - 1 - 9 - 9, 0, 176 + RaisedScreen.getSignal(percentX) * 8, 10, 8);
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/icons.png"), 43, offset - 1 - 9, 0, 176 + RaisedScreen.getSignal(percentY) * 8, 10, 8);
                break;
            }
            case TOASTS: {
                guiGraphics.m_280218_(ResourceLocation.m_135820_((String)"textures/gui/toasts.png"), -131, offset - 32, 0, 0, 160, 32);
                guiGraphics.m_280203_(Items.f_42437_.m_7968_(), -83, offset - 32 + 8);
                guiGraphics.m_280056_(this.f_96547_, translatableX.getString() + ": " + x, -61, offset - 32 + 7, -256, false);
                guiGraphics.m_280056_(this.f_96547_, translatableY.getString() + ": " + y, -61, offset - 32 + 18, -1, false);
                break;
            }
            case OTHER: {
                guiGraphics.m_280488_(this.f_96547_, translatableX.getString() + ": " + x, -83, offset - 8 - 8 - 4 - 8, -1);
                guiGraphics.m_280488_(this.f_96547_, translatableY.getString() + ": " + y, -83, offset - 8 - 8, -1);
            }
        }
        RenderSystem.disableBlend();
        guiGraphics.m_280168_().m_85849_();
    }

    public static int getSignal(float percent) {
        int i = percent > 0.8f ? 0 : (percent > 0.6f ? 1 : (percent > 0.4f ? 2 : (percent > 0.2f ? 3 : (percent > 0.0f ? 4 : 5))));
        return i;
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        if (RaisedOptions.options.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return true;
    }
}

