/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconToggleButton
extends Button {
    public final ResourceLocation texture;
    public final int textureWidth;
    public final int textureHeight;
    public boolean toggled;
    public static final ResourceLocation TEXTURE = ResourceLocation.m_135820_((String)"textures/gui/widgets.png");

    public IconToggleButton(int x, int y, int width, int height, Component message, int textureWidth, int textureHeight, ResourceLocation texture, Button.OnPress onPress, Button.CreateNarration createNarration, boolean toggled) {
        super(x, y, width, height, message, onPress, createNarration == null ? f_252438_ : createNarration);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.texture = texture;
        this.toggled = toggled;
    }

    public static Builder builder(Component message, Button.OnPress onPress, boolean toggled) {
        return new Builder(message, onPress, toggled);
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.texture != null) {
            RenderSystem.disableDepthTest();
            int v = !this.isToggled() ? (this.m_198029_() ? 86 : 66) : 46;
            guiGraphics.m_280027_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, v);
            guiGraphics.m_280163_(this.texture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
            RenderSystem.enableDepthTest();
        }
    }

    public void m_280139_(GuiGraphics guiGraphics, Font font, int color) {
    }

    public static class Builder {
        public final Component message;
        public final Button.OnPress onPress;
        public Tooltip tooltip;
        public int x;
        public int y;
        public int width = 150;
        public int height = 20;
        public ResourceLocation texture;
        public int textureWidth;
        public int textureHeight;
        public Button.CreateNarration createNarration;
        public boolean toggled;

        public Builder(Component message, Button.OnPress onPress, boolean toggled) {
            this.message = message;
            this.onPress = onPress;
            this.toggled = toggled;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder tooltip(Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder texture(ResourceLocation texture, int width, int height) {
            this.texture = texture;
            this.textureWidth = width;
            this.textureHeight = height;
            return this;
        }

        public Builder createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public IconToggleButton build() {
            if (this.texture == null) {
                throw new IllegalStateException("Sprite not set");
            }
            IconToggleButton iconToggleButtonWidget = new IconToggleButton(this.x, this.y, this.width, this.height, this.message, this.textureWidth, this.textureHeight, this.texture, this.onPress, this.createNarration, this.toggled);
            iconToggleButtonWidget.m_257544_(this.tooltip);
            return iconToggleButtonWidget;
        }
    }
}

