/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.slib.api.server.position.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerPlayerSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.server.audio.source.VoiceServerProximitySource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0002R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerPlayerSource;", "Lsu/plo/voice/server/audio/source/VoiceServerProximitySource;", "Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "Lsu/plo/voice/api/server/audio/source/ServerPlayerSource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "player", "Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;ZLsu/plo/voice/api/server/player/VoiceServerPlayer;)V", "getPlayer", "()Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "position", "Lsu/plo/slib/api/server/position/ServerPos3d;", "getPosition", "()Lsu/plo/slib/api/server/position/ServerPos3d;", "sourceInfo", "getSourceInfo", "()Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "filterSelf", "Lsu/plo/voice/api/server/player/VoicePlayer;", "filterVanish", "common"})
public final class VoiceServerPlayerSource
extends VoiceServerProximitySource<PlayerSourceInfo>
implements ServerPlayerSource {
    @NotNull
    private final VoiceServerPlayer player;

    public VoiceServerPlayerSource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull ServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo, @NotNull VoiceServerPlayer player) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        super(voiceServer, addon, uUID, line, decoderInfo, stereo);
        this.player = player;
        this.addFilter(arg_0 -> VoiceServerPlayerSource._init_$lambda$0(new Function1<VoicePlayer, Boolean>((Object)this){

            @Override
            @NotNull
            public final Boolean invoke(@NotNull VoicePlayer p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((VoiceServerPlayerSource)this.receiver).filterSelf(p0);
            }
        }, arg_0));
        this.addFilter(arg_0 -> VoiceServerPlayerSource._init_$lambda$1(new Function1<VoicePlayer, Boolean>((Object)this){

            @Override
            @NotNull
            public final Boolean invoke(@NotNull VoicePlayer p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((VoiceServerPlayerSource)this.receiver).filterVanish(p0);
            }
        }, arg_0));
    }

    @Override
    @NotNull
    public VoiceServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public ServerPos3d getPosition() {
        return this.getPlayer().getInstance().getServerPosition();
    }

    @Override
    @NotNull
    public PlayerSourceInfo getSourceInfo() {
        return new PlayerSourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.getAngle(), this.getPlayer().createPlayerInfo());
    }

    private final boolean filterSelf(VoicePlayer player) {
        return !Intrinsics.areEqual(player, this.getPlayer());
    }

    private final boolean filterVanish(VoicePlayer player) {
        Intrinsics.checkNotNull(player, "null cannot be cast to non-null type su.plo.voice.api.server.player.VoiceServerPlayer");
        McServerPlayer mcServerPlayer = ((VoiceServerPlayer)player).getInstance();
        McServerPlayer mcServerPlayer2 = this.getPlayer().getInstance();
        Intrinsics.checkNotNullExpressionValue(mcServerPlayer2, "getInstance(...)");
        return mcServerPlayer.canSee(mcServerPlayer2);
    }

    private static final boolean _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

