/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.line;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.line.ServerPlayerSetManager;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.audio.source.ServerBroadcastSource;
import su.plo.voice.api.server.audio.source.ServerDirectSource;
import su.plo.voice.api.server.connection.UdpConnectionManager;
import su.plo.voice.api.server.event.audio.source.ServerSourceCreatedEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourceRemovedEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.line.VoiceSourceLine;
import su.plo.voice.server.audio.line.VoiceBaseServerSourceLine;
import su.plo.voice.server.audio.line.VoiceServerPlayerSetManager;
import su.plo.voice.server.audio.source.VoiceServerBroadcastSource;
import su.plo.voice.server.audio.source.VoiceServerDirectSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0004J\b\u0010#\u001a\u00020!H\u0016J\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\"\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u001a\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0-2\u0006\u0010.\u001a\u00020\u001aH\u0016J\u0010\u0010/\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u00100\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b01H\u0016J\u0010\u00102\u001a\u00020!2\u0006\u0010.\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lsu/plo/voice/server/audio/line/VoiceBaseServerSourceLine;", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "Lsu/plo/voice/proto/data/audio/line/VoiceSourceLine;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "name", "", "translation", "icon", "defaultVolume", "", "weight", "", "withPlayers", "", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;DIZ)V", "getAddon", "()Lsu/plo/voice/api/addon/AddonContainer;", "playerSetManager", "Lsu/plo/voice/api/server/audio/line/ServerPlayerSetManager;", "getPlayerSetManager", "()Lsu/plo/voice/api/server/audio/line/ServerPlayerSetManager;", "sourceById", "", "Ljava/util/UUID;", "Lsu/plo/voice/api/server/audio/source/ServerAudioSource;", "getSourceById", "()Ljava/util/Map;", "getVoiceServer", "()Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "addSource", "", "source", "clear", "createBroadcastSource", "Lsu/plo/voice/api/server/audio/source/ServerBroadcastSource;", "stereo", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "createDirectSource", "Lsu/plo/voice/api/server/audio/source/ServerDirectSource;", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "Ljava/util/Optional;", "sourceId", "getSourceLineForPlayer", "getSources", "", "removeSource", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nVoiceBaseServerSourceLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceBaseServerSourceLine.kt\nsu/plo/voice/server/audio/line/VoiceBaseServerSourceLine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public abstract class VoiceBaseServerSourceLine
extends VoiceSourceLine
implements BaseServerSourceLine {
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final AddonContainer addon;
    @Nullable
    private final ServerPlayerSetManager playerSetManager;
    @NotNull
    private final Map<UUID, ServerAudioSource<?>> sourceById;

    public VoiceBaseServerSourceLine(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull String name, @NotNull String translation, @NotNull String icon, double defaultVolume, int weight, boolean withPlayers) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(translation, "translation");
        Intrinsics.checkNotNullParameter(icon, "icon");
        super(name, translation, icon, defaultVolume, weight, null);
        this.voiceServer = voiceServer;
        this.addon = addon;
        this.playerSetManager = withPlayers ? (ServerPlayerSetManager)new VoiceServerPlayerSetManager(this) : null;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        this.sourceById = concurrentMap;
    }

    @NotNull
    protected PlasmoBaseVoiceServer getVoiceServer() {
        return this.voiceServer;
    }

    @Override
    @NotNull
    public AddonContainer getAddon() {
        return this.addon;
    }

    @Override
    @Nullable
    public ServerPlayerSetManager getPlayerSetManager() {
        return this.playerSetManager;
    }

    @NotNull
    protected final Map<UUID, ServerAudioSource<?>> getSourceById() {
        return this.sourceById;
    }

    @Override
    @NotNull
    public VoiceSourceLine getSourceLineForPlayer(@NotNull VoicePlayer player) {
        VoiceSourceLine voiceSourceLine;
        Intrinsics.checkNotNullParameter(player, "player");
        ServerPlayerSetManager serverPlayerSetManager = this.getPlayerSetManager();
        if (serverPlayerSetManager != null) {
            VoiceSourceLine voiceSourceLine2;
            ServerPlayerSetManager it = serverPlayerSetManager;
            boolean bl = false;
            VoiceSourceLine it2 = voiceSourceLine2 = new VoiceSourceLine(this.name, this.translation, this.icon, this.defaultVolume, this.weight, it.getPlayerSet(player).getPlayers().stream().map(arg_0 -> VoiceBaseServerSourceLine.getSourceLineForPlayer$lambda$2$lambda$0(getSourceLineForPlayer.1.1.INSTANCE, arg_0)).collect(Collectors.toSet()));
            boolean bl2 = false;
            this.players = Sets.newHashSet();
            voiceSourceLine = voiceSourceLine2;
        } else {
            voiceSourceLine = this;
        }
        return voiceSourceLine;
    }

    @Override
    @NotNull
    public ServerBroadcastSource createBroadcastSource(boolean stereo, @Nullable CodecInfo decoderInfo) {
        PlasmoBaseVoiceServer plasmoBaseVoiceServer = this.getVoiceServer();
        UdpConnectionManager<?, ?> udpConnectionManager = this.getVoiceServer().getUdpConnectionManager();
        Intrinsics.checkNotNullExpressionValue(udpConnectionManager, "getUdpConnectionManager(...)");
        VoiceServerBroadcastSource voiceServerBroadcastSource = new VoiceServerBroadcastSource(plasmoBaseVoiceServer, udpConnectionManager, this.getAddon(), this, decoderInfo, stereo);
        ServerAudioSource p0 = voiceServerBroadcastSource;
        boolean bl = false;
        this.addSource(p0);
        return voiceServerBroadcastSource;
    }

    @Override
    @NotNull
    public ServerDirectSource createDirectSource(@NotNull VoicePlayer player, boolean stereo, @Nullable CodecInfo decoderInfo) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlasmoBaseVoiceServer plasmoBaseVoiceServer = this.getVoiceServer();
        UdpConnectionManager<?, ?> udpConnectionManager = this.getVoiceServer().getUdpConnectionManager();
        Intrinsics.checkNotNullExpressionValue(udpConnectionManager, "getUdpConnectionManager(...)");
        VoiceServerDirectSource voiceServerDirectSource = new VoiceServerDirectSource(plasmoBaseVoiceServer, udpConnectionManager, this.getAddon(), this, decoderInfo, stereo, player);
        ServerAudioSource p0 = voiceServerDirectSource;
        boolean bl = false;
        this.addSource(p0);
        return voiceServerDirectSource;
    }

    @Override
    public void removeSource(@NotNull UUID sourceId) {
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        ServerAudioSource<?> serverAudioSource = this.sourceById.remove(sourceId);
        if (serverAudioSource == null) {
            return;
        }
        ServerAudioSource<?> source2 = serverAudioSource;
        this.getVoiceServer().getEventBus().fire((Event)new ServerSourceRemovedEvent(source2));
    }

    @Override
    @NotNull
    public Optional<ServerAudioSource<?>> getSourceById(@NotNull UUID sourceId) {
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        Optional<ServerAudioSource<?>> optional = Optional.ofNullable(this.sourceById.get(sourceId));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @Override
    @NotNull
    public Collection<ServerAudioSource<?>> getSources() {
        return this.sourceById.values();
    }

    @Override
    public void clear() {
        this.sourceById.clear();
    }

    protected final void addSource(@NotNull ServerAudioSource<?> source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Map<UUID, ServerAudioSource<?>> map2 = this.sourceById;
        UUID uUID = source2.getId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getId(...)");
        map2.put(uUID, source2);
        this.getVoiceServer().getEventBus().fire((Event)new ServerSourceCreatedEvent(source2));
    }

    private static final McGameProfile getSourceLineForPlayer$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (McGameProfile)$tmp0.invoke(p0);
    }
}

