/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.extensions.AABBKt;
import su.plo.lib.mod.extensions.EntityKt;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.key.MouseScrollEvent;
import su.plo.voice.client.extension.OptionsKt;

public final class PlayerVolumeAction {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private Player focusedPlayer;
    private long lastScroll;

    public PlayerVolumeAction(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
        voiceClient.getHotkeys().getHotkey("key.plasmovoice.general.action").ifPresent(key -> key.addPressListener(this::onButton));
    }

    public boolean isShown(@NotNull Player player) {
        return this.focusedPlayer != null && this.focusedPlayer.m_20148_().equals(player.m_20148_()) && this.lastScroll != 0L && System.currentTimeMillis() - this.lastScroll < 1000L;
    }

    @EventSubscribe
    public void onScroll(@NotNull MouseScrollEvent event) {
        if (this.focusedPlayer != null && Minecraft.m_91087_().f_91080_ == null) {
            this.lastScroll = System.currentTimeMillis();
            DoubleConfigEntry volume = this.config.getVoice().getVolumes().getVolume("source_" + this.focusedPlayer.m_20148_());
            double value = (Double)volume.value() + (event.getVertical() > 0.0 ? 0.05 : -0.05);
            volume.set((double)(Math.round(value * volume.getMax() * 100.0 / 5.0) * 5L) / (volume.getMax() * 100.0));
            event.setCancelled(true);
        }
    }

    private void onButton(@NotNull Hotkey.Action action) {
        if (!this.voiceClient.getServerConnection().isPresent()) {
            return;
        }
        if (action == Hotkey.Action.DOWN) {
            ServerConnection serverConnection = this.voiceClient.getServerConnection().get();
            this.getPlayerBySight().filter(player -> serverConnection.getPlayerById(player.m_20148_()).isPresent()).ifPresent(player -> {
                this.focusedPlayer = player;
            });
        } else if (action == Hotkey.Action.UP) {
            this.focusedPlayer = null;
            this.lastScroll = 0L;
        }
    }

    private Optional<Player> getPlayerBySight() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null || player == null) {
            return Optional.empty();
        }
        Vec3 playerPos = EntityKt.eyePosition((Entity)player);
        Vec3 rotVector = player.m_20154_();
        for (int i = 0; i < OptionsKt.renderDistanceValue(Minecraft.m_91087_().f_91066_) * 16; ++i) {
            playerPos = playerPos.m_82549_(rotVector);
            BlockPos blockPos = new BlockPos((int)Math.floor(playerPos.f_82479_), (int)Math.floor(playerPos.f_82480_), (int)Math.floor(playerPos.f_82481_));
            BlockState state = level.m_8055_(blockPos);
            boolean isSolid = state.m_60804_((BlockGetter)level, blockPos);
            if (!state.m_60795_() && isSolid) break;
            AABB box = AABBKt.ofSize(playerPos.m_82492_(0.0, 1.0, 0.0), 1.0, 2.0, 1.0);
            for (Player playerEntity : level.m_6907_()) {
                if (!box.m_82393_(playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_()) || playerEntity.m_20177_((Player)player) || player.m_20148_().equals(playerEntity.m_20148_())) continue;
                return Optional.of(playerEntity);
            }
        }
        return Optional.empty();
    }
}

