/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.hotkey;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.api.client.config.hotkey.Hotkeys;

public final class VoiceHotkey
implements Hotkey {
    private final Set<Hotkey.OnPress> onPress = new CopyOnWriteArraySet<Hotkey.OnPress>();
    private final Set<Hotkey.OnKeysChange> onKeysChange = new CopyOnWriteArraySet<Hotkey.OnKeysChange>();
    private final Hotkeys keyBindings;
    private final String name;
    private final Set<Hotkey.Key> keys = new CopyOnWriteArraySet<Hotkey.Key>();
    private final boolean anyContext;
    private boolean pressed;

    public VoiceHotkey(@NotNull Hotkeys keyBindings, @NotNull String name, @NotNull List<Hotkey.Key> keys2, boolean anyContext) {
        this.keyBindings = (Hotkeys)Preconditions.checkNotNull((Object)keyBindings, (Object)"keyBindings");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(keys2, (Object)"keys");
        this.keys.addAll(keys2);
        this.anyContext = anyContext;
    }

    @Override
    public Set<Hotkey.Key> getKeys() {
        return this.keys;
    }

    @Override
    public void setKeys(@NotNull Set<Hotkey.Key> newKeys) {
        this.keys.clear();
        this.keys.addAll(newKeys);
        this.onKeysChange.forEach(action -> action.onKeysChange(newKeys));
        this.resetState();
    }

    @Override
    public void resetState() {
        this.pressed = false;
    }

    @Override
    public void updateState(@NotNull Hotkey.Action keyAction) {
        if (this.getKeys().size() > 0) {
            if (keyAction == Hotkey.Action.DOWN && !this.pressed && this.keyBindings.getPressedKeys().containsAll(this.keys)) {
                this.pressed = true;
                this.onPress.forEach(action -> action.onPress(Hotkey.Action.DOWN));
            } else if (this.pressed && !this.keyBindings.getPressedKeys().containsAll(this.keys)) {
                this.pressed = false;
                this.onPress.forEach(action -> action.onPress(Hotkey.Action.UP));
            }
        }
    }

    @Override
    public void addPressListener(@NotNull Hotkey.OnPress onPress) {
        this.onPress.add(onPress);
    }

    @Override
    public void removePressListener(@NotNull Hotkey.OnPress onPress) {
        this.onPress.remove(onPress);
    }

    @Override
    public void clearPressListener() {
        this.onPress.clear();
    }

    @Override
    public void addKeysChangeListener(@NotNull Hotkey.OnKeysChange onKeysChange) {
        this.onKeysChange.add(onKeysChange);
    }

    @Override
    public void removeKeysChangeListener(@NotNull Hotkey.OnKeysChange onKeysChange) {
        this.onKeysChange.remove(onKeysChange);
    }

    @NotNull
    public VoiceHotkey copy() {
        return new VoiceHotkey(this.keyBindings, this.name, new ArrayList<Hotkey.Key>(this.keys), this.anyContext);
    }

    @Override
    public void clearKeysChangeListeners() {
        this.onKeysChange.clear();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Hotkey) {
            Hotkey keyBinding = (Hotkey)object;
            return this.hashCode() == keyBinding.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.keys.hashCode());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAnyContext() {
        return this.anyContext;
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }
}

