/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.personality.core.other;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.personality.client.ClimbAnimation;
import com.teamabnormals.personality.common.network.MessageS2CSyncCrawl;
import com.teamabnormals.personality.core.Personality;
import com.teamabnormals.personality.core.PersonalityConfig;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="personality")
public class PersonalityEvents {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        UUID uuid = player.m_20148_();
        PersonalityEvents.setBesideClimbableBlock(player, player.m_6147_() && (player.f_19791_ != player.m_20186_() || player.m_6144_()));
        if ((Personality.SITTING_PLAYERS.contains(uuid) || Personality.SYNCED_SITTING_PLAYERS.contains(uuid)) && !PersonalityEvents.testCrawl(player) && PersonalityEvents.testSit(player)) {
            Personality.SITTING_PLAYERS.remove(uuid);
            Personality.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageS2CSyncCrawl(uuid, false));
        }
    }

    @SubscribeEvent
    public static void onStartTrackingPlayer(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Personality.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new MessageS2CSyncCrawl(player.m_20148_(), player.getForcedPose() == Pose.SWIMMING));
        }
    }

    @SubscribeEvent
    public static void onStopTrackingPlayer(PlayerEvent.StopTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Personality.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new MessageS2CSyncCrawl(player.m_20148_(), false));
        }
    }

    @SubscribeEvent
    public static void onEntitySize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if ((Personality.SITTING_PLAYERS.contains(player.m_20148_()) || Personality.SYNCED_SITTING_PLAYERS.contains(player.m_20148_())) && PersonalityEvents.testSit(player)) {
            EntityDimensions size = Player.f_36088_;
            event.setNewSize(new EntityDimensions(size.f_20377_, size.f_20378_ - 0.5f, size.f_20379_));
            event.setNewEyeHeight(player.m_6431_(Pose.STANDING, size) - 0.5f);
        }
    }

    public static boolean testSit(Player player) {
        return (player.m_20089_() == Pose.STANDING || player.m_20089_() == Pose.CROUCHING) && !player.m_20159_() && player.m_20096_();
    }

    public static boolean testCrawl(Player player) {
        return !Personality.SITTING_PLAYERS.contains(player.m_20148_()) && !Personality.SYNCED_SITTING_PLAYERS.contains(player.m_20148_()) && !player.m_20159_();
    }

    public static boolean isClimbing(Player player) {
        return !player.m_20096_() && PersonalityEvents.isBesideClimbableBlock(player) && (Boolean)PersonalityConfig.CLIENT.climbingAnimation.get() != false;
    }

    public static boolean isBesideClimbableBlock(Player player) {
        IDataManager data = (IDataManager)player;
        return ((Byte)data.getValue(Personality.CLIMBING) & 1) != 0;
    }

    public static void setBesideClimbableBlock(Player player, boolean climbing) {
        IDataManager data = (IDataManager)player;
        byte b0 = (Byte)data.getValue(Personality.CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        data.setValue(Personality.CLIMBING, (Object)b0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getClimbingAnimationScale(Player player, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)((ClimbAnimation)player).getPrevClimbAnim(), (float)((ClimbAnimation)player).getClimbAnim()) / 4.0f;
    }
}

