/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.network.ScalePacket;

public class ScalePayload
extends ScalePacket {
    public ScalePayload(Entity entity, Collection<ScaleData> scales) {
        super(entity, scales);
    }

    public ScalePayload(FriendlyByteBuf buf) {
        super(buf);
    }

    public static void handle(ScalePayload msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft client = Minecraft.m_91087_();
            Entity entity = client.f_91073_.m_6815_(msg.entityId);
            if (entity != null) {
                msg.syncedScales.forEach((typeId, scaleData) -> {
                    if (ScaleRegistries.SCALE_TYPES.containsKey(typeId)) {
                        ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, typeId).getScaleData(entity).readNbt((CompoundTag)scaleData);
                    }
                });
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

